% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams_method.R
\docType{class}
\name{ngrams-class}
\alias{ngrams-class}
\alias{ngrams}
\alias{ngrams,partition-method}
\alias{ngrams,partitionBundle-method}
\title{Get N-Grams}
\usage{
ngrams(.Object, ...)

\S4method{ngrams}{partition}(.Object, n = 2, pAttribute = "word",
  char = NULL, progress = FALSE, ...)

\S4method{ngrams}{partitionBundle}(.Object, n = 2, char = NULL,
  pAttribute = "word", mc = FALSE, progress = FALSE, ...)
}
\arguments{
\item{.Object}{object of class \code{partition}}

\item{...}{further parameters}

\item{n}{number of tokens/characters}

\item{pAttribute}{the p-attribute to use (can be > 1)}

\item{char}{if NULL, tokens will be counted, else characters, keeping only those provided by a character vector}

\item{progress}{logical}

\item{mc}{logical, whether to use multicore, passed into call to \code{blapply} (see respective documentation)}
}
\description{
Count n-grams, either of words, or of characters.
}
\examples{
  use("polmineR")
  P <- partition("GERMAPARLMINI", date = "2009-10-27")
  ngramObject <- ngrams(P, n = 2, pAttribute = "word", char = NULL)
  # a more complex scenario: get most frequent ADJA/NN-combinations
  ngramObject <- ngrams(P, n = 2, pAttribute = c("word", "pos"), char = NULL)
  ngramObject2 <- subset(
    ngramObject,
    ngramObject[["1_pos"]] == "ADJA"  & ngramObject[["2_pos"]] == "NN"
    )
  ngramObject2@stat[, "1_pos" := NULL, with = FALSE][, "2_pos" := NULL, with = FALSE]
  ngramObject3 <- sort(ngramObject2, by = "count")
  head(ngramObject3)
}
