% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwl.R
\name{control_rwl}
\alias{control_rwl}
\title{Control arguments for Residual Weighted Learning}
\usage{
control_rwl(
  moPropen,
  moMain,
  regime,
  fSet = NULL,
  lambdas = 2,
  cvFolds = 0L,
  kernel = "linear",
  kparam = NULL,
  responseType = "continuous",
  verbose = 2L
)
}
\arguments{
\item{moPropen}{Propensity model of class "ModelObj", see \link[modelObj:modelObj]{modelObj::modelObj}.}

\item{moMain}{Main effects outcome model of class "ModelObj".}

\item{regime}{An object of class \link{formula} specifying the design of the policy/regime.}

\item{fSet}{A function or NULL defining subset structure.}

\item{lambdas}{Numeric or numeric vector. Penalty parameter.}

\item{cvFolds}{Integer. Number of folds for cross-validation of the parameters.
\code{"logit"}, \code{"exp"}, \code{"hinge"}, \code{"sqhinge"}, \code{"huber"}.}

\item{kernel}{The options are \code{"linear"}, \code{"poly"}, \code{"radial"}.}

\item{kparam}{Numeric. Kernel parameter}

\item{responseType}{Character string. Options are \code{"continuous"},
\code{"binary"}, \code{"count"}.}

\item{verbose}{Integer.}
}
\value{
list of (default) control arguments.
}
\description{
\code{control_rwl} sets the default control arguments
for residual learning , \code{type = "rwl"}.
The arguments are passed directly to \code{\link[DynTxRegime:rwl]{DynTxRegime::rwl()}} if not
specified otherwise.
}
