% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_id}
\alias{get_id}
\title{Get IDs}
\usage{
get_id(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
Character vector.
}
\description{
\code{get_id} returns the ID for every observation in the policy data object.
}
\examples{
### Two stages:
d <- sim_two_stage(5e2, seed=1)
# constructing policy_data object:
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting the IDs:
head(get_id(pd))
}
