% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_shift_and_fill}
\alias{Expr_shift_and_fill}
\alias{shift_and_fill}
\title{Shift and fill values}
\usage{
Expr_shift_and_fill(periods, fill_value)
}
\arguments{
\item{periods}{numeric number of periods to shift, may be negative.}

\item{fill_value}{Fill None values with the result of this expression.}
}
\value{
Expr
}
\description{
Shift the values by a given period and fill the resulting null values.
}
\details{
See Inf,NaN,NULL,Null/NA translations here \code{\link[polars]{docs_translations}}
}
\examples{
pl$select(
  pl$lit(0:3),
  pl$lit(0:3)$shift_and_fill(-2, fill_value = 42)$alias("shift-2"),
  pl$lit(0:3)$shift_and_fill(2, fill_value = pl$lit(42) / 2)$alias("shift+2")
)
}
\keyword{Expr}
