% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_weekday}
\alias{ExprDT_weekday}
\alias{(Expr)$dt$weekday}
\title{Weekday}
\format{
function
}
\value{
Expr of weekday as UInt32
}
\description{
Extract the week day from the underlying Date representation.
Applies to Date and Datetime columns.
Returns the ISO weekday number where monday = 1 and sunday = 7
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    as.Date("2020-12-25"),
    as.Date("2021-1-05"),
    interval = "1d",
    time_zone = "GMT",
    lazy = FALSE
  )
)
df$with_columns(
  pl$col("date")$dt$weekday()$alias("weekday")
)
}
\keyword{ExprDT}
