% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_rmd.R
\name{validate_rmd}
\alias{validate_rmd}
\title{Modify \strong{pointblank} validation testing options within R Markdown documents}
\usage{
validate_rmd(summary = TRUE, log_to_file = NULL)
}
\arguments{
\item{summary}{If \code{TRUE} (the default), then there will be a leading summary
of all validations in the rendered R Markdown document. With \code{FALSE}, this
element is not shown.}

\item{log_to_file}{An option to log errors to a text file. By default, no
logging is done but \code{TRUE} will write log entries to
\code{"validation_errors.log"} in the working directory. To both enable logging
and to specify a file name, include a path to a log file of the desired
name.}
}
\description{
Using \strong{pointblank} in an R Markdown workflow is enabled by default once the
\strong{pointblank} library is loaded. The framework allows for validation testing
within specialized validation code chunks where the \code{validate = TRUE} option
is set. Using \strong{pointblank} validation functions on data in these
marked code chunks will flag overall failure if the stop threshold is
exceeded anywhere. All errors are reported in the validation code chunk after
rendering the document to HTML, where green or red status buttons indicate
whether all validations succeeded or failures occurred. Clicking any such
button reveals the otherwise hidden validation statements and their error
messages (if any). While the framework for such testing is set up by default,
the \code{validate_rmd()} function offers an opportunity to set UI and logging
options.
}
\section{Function ID}{

1-4
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_get}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()}
}
\concept{Planning and Prep}
