% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_deactivate.R
\name{deactivate_steps}
\alias{deactivate_steps}
\title{Deactivate one or more of an \emph{agent}'s validation steps}
\usage{
deactivate_steps(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{i}{The validation step number, which is assigned to each validation
step in the order of definition.}
}
\value{
A \code{ptblank_agent} object.
}
\description{
Should the deactivation of one or more validation steps be necessary after
creation of the validation plan for an \emph{agent}, the \code{deactivate_steps()}
function will be helpful for that. This has the same effect as using the
\code{active = FALSE} option (\code{active} is an argument in all validation functions)
for the selected validation steps. Please note that this directly edits the
validation step, wiping out any function that may have been defined for
whether the step should be active or not.
}
\section{Function ID}{

9-6
}

\examples{
# Create an agent that has the
# `small_table` object as the
# target table, add a few
# validation steps, and then use
# `interrogate()`
agent_1 <- 
  create_agent(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  col_exists(columns = vars(date)) \%>\%
  col_vals_regex(
    columns = vars(b),
    regex = "[0-9]-[a-z]{3}-[0-9]"
  ) \%>\%
  interrogate()
  
# The second validation step is
# now being reconsidered and may
# be either phased out or improved
# upon; in the interim period it
# was decided that the step should
# be deactivated for now
agent_2 <-
  agent_1 \%>\%
  deactivate_steps(i = 2) \%>\%
  interrogate()

}
\seealso{
For the opposite behavior, use the \code{\link[=activate_steps]{activate_steps()}} function.

Other Object Ops: 
\code{\link{activate_steps}()},
\code{\link{export_report}()},
\code{\link{remove_steps}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
