% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_time_shift}
\alias{tt_time_shift}
\title{Table Transformer: shift the times of a table}
\usage{
tt_time_shift(tbl, time_shift = "0y 0m 0d 0H 0M 0S")
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}

\item{time_shift}{Either a character-based representation that specifies the
time difference by which all time values in time-based columns will be
shifted, or, a \code{difftime} object. The character string is constructed in
the format \code{"0y 0m 0d 0H 0M 0S"} and individual time components can be
omitted (i.e., \code{"1y 5d"} is a valid specification of shifting time values
ahead one year and five days). Adding a \code{"-"} at the beginning of the
string (e.g., \code{"-2y"}) will shift time values back.}
}
\value{
A data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object
depending on what was provided as \code{tbl}.
}
\description{
With any table object containing date or date-time columns, these values can
be precisely shifted with \code{tt_time_shift()} and specification of the time
shift. We can either provide a string with the time shift components and the
shift direction (like \code{"-4y 10d"}) or a \code{difftime} object (which can be
created via \strong{lubridate} expressions or by using the \code{\link[base:difftime]{base::difftime()}}
function).
}
\details{
The \code{time_shift} specification cannot have a higher time granularity than the
least granular time column in the input table. Put in simpler terms, if there
are any date-based based columns (or just a single date-based column) then
the time shifting can only be in terms of years, months, and days. Using a
\code{time_shift} specification of \code{"20d 6H"} in the presence of any dates will
result in a truncation to \code{"20d"}. Similarly, a \code{difftime} object will be
altered in the same circumstances, however, the object will resolved to an
exact number of days through rounding.
}
\section{Function ID}{

12-5
}

\examples{
# With the `game_revenue` dataset,
# which has entries in the first
# 21 days of 2015, move all of the
# date and date-time values to the
# beginning of 2021
tt_time_shift(
  tbl = game_revenue,
  time_shift = "6y"
)

# Keeping only the `date_time` and
# `a`-`f` columns of `small_table`,
# shift the times back 2 days and
# 12 hours
small_table \%>\%
  dplyr::select(-date) \%>\%
  tt_time_shift("-2d 12H")

}
\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
