% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationResults.R
\name{SimulationResults}
\alias{SimulationResults}
\title{R6 class representing simulation results.}
\description{
\code{\link[R6:R6Class]{R6}} class for encapsulating and dynamically generating
spatially-explicit simulation results, as well as optional re-generated
\code{\link{Generator}} outputs.
}
\examples{
# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")
# Sample results occupancy (ignore cell 2 in last 3 time steps)
occupancy_raster <- region$raster_from_values(array(1, c(7, 13)))
occupancy_raster[region$region_indices][2, 11:13] <- 0
occupancy_raster[region$region_indices]
# Simulation example results
example_results <- list(abundance = region$raster_from_values(
  t(apply(matrix(11:17), 1,
          function(n) c(rep(n, 3), round(n*exp(-(0:9)/log(n))))))))
example_results$abundance[region$region_indices]
# Simulation results object
sim_results <- SimulationResults$new(region = region,
                                     time_steps = 13,
                                     burn_in_steps = 3,
                                     occupancy_mask = occupancy_raster)
# Clone (for each simulation results)
results_clone <- sim_results$new_clone(results = example_results)
results_clone$get_attribute("abundance")
results_clone$get_attribute("abundance")[region$region_indices]
results_clone$all$get_attribute("abundance")
results_clone$get_attribute("all$abundance")

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{SimulationResults}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{burn_in_steps}}{Optional number of initial 'burn-in' time steps to be ignored.}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for each cell at each time-step of the simulation including burn-in.}

\item{\code{all}}{Nested simulation results for all cells.}

\item{\code{parent}}{Parent simulation results for individual cells.}

\item{\code{default}}{Default value/attribute utilized when applying primitive metric functions (e.g. max) to the results.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimulationResults-new}{\code{SimulationResults$new()}}
\item \href{#method-SimulationResults-new_clone}{\code{SimulationResults$new_clone()}}
\item \href{#method-SimulationResults-get_attribute_names}{\code{SimulationResults$get_attribute_names()}}
\item \href{#method-SimulationResults-get_attributes}{\code{SimulationResults$get_attributes()}}
\item \href{#method-SimulationResults-set_attributes}{\code{SimulationResults$set_attributes()}}
\item \href{#method-SimulationResults-clone}{\code{SimulationResults$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets attributes from a results list or file, and sets object attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$new(results = NULL, parent = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results}}{A list containing results or a file path to simulation results.}

\item{\code{parent}}{Parent simulation results for individual cells (used when nesting a simulation results clone for all cells).}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-new_clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-new_clone}{}}}
\subsection{Method \code{new_clone()}}{
Creates a new (re-initialized) object of the current (inherited) object class with optionally passed parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$new_clone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via the inherited class constructor (defined in initialize and run via new).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New object of the current (inherited) class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-get_attribute_names"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-get_attribute_names}{}}}
\subsection{Method \code{get_attribute_names()}}{
Returns an array of all attribute names including public and private model attributes, as well as attached attributes, error and warning messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$get_attribute_names(all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{all}}{Boolean to indicate if a nested list for all cells (when present) should be also listed (default is FALSE).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Array of all attribute names with optional inclusion of attribute names of nested results for all cells.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Returns a list of values for selected attributes or attribute aliases (when array of parameter names provided) or all attributes (when no params).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$get_attributes(params = NULL, remove_burn_in = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Array of attribute names to return (all when NULL).}

\item{\code{remove_burn_in}}{Boolean to indicate whether or not to remove burn-in steps from the attribute values (default = TRUE; mostly for internal use).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selected or all attributes values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-set_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-set_attributes}{}}}
\subsection{Method \code{set_attributes()}}{
Sets given attributes (optionally via alias names) individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$set_attributes(params = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{List of parameters/attributes.}

\item{\code{...}}{Parameters/attributes passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimulationResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimulationResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
