% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_results.R
\name{population_results}
\alias{population_results}
\title{Nested functions for initializing, calculating and collecting population simulator results.}
\usage{
population_results(
  replicates,
  time_steps,
  coordinates,
  initial_abundance,
  results_selection = NULL,
  result_stages = NULL
)
}
\arguments{
\item{replicates}{Number of replicate simulation runs.}

\item{time_steps}{Number of simulation time steps.}

\item{coordinates}{Data frame (or matrix) of X-Y population coordinates.}

\item{initial_abundance}{Matrix of initial abundances at each stage (in rows) for each population (in columns).}

\item{results_selection}{List of results selection from: "abundance" (default), "ema", "extirpation", "extinction_location", "harvested", "occupancy"; "summarize" (default) or "replicate".}

\item{result_stages}{Array of booleans or numeric (0, 1, 2, ...) for each stage to indicate which stages are included/combined (each unique digit > 0; optionally named) in the results (default is 1 for all stages).}
}
\value{
List of result functions:
  \describe{
    \item{\code{initialize_attributes = function())}}{Constructs and returns an initialized nested list for the selected result attributes.}
    \item{\code{initialize_replicate = function(results)}}{Initializes and returns nested result attributes at the start of each replicate.}
    \item{\code{calculate_at_timestep = function(r, tm, stage_abundance, harvested, results)}}{Appends and calculates (non-NULL) results and returns nested result attributes at the end of each time step (tm) within replicate (r).}
    \item{\code{finalize_attributes = function(results)}}{Finalizes result calculations at the end of the simulation.}
  }
}
\description{
Modular functions for the population simulator for initializing, calculating and
collecting simulator results.
}
