% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssys_gmm.R
\name{ssys_gmm}
\alias{ssys_gmm}
\title{Suboptimal multi-step System-GMM estimator for AR(1) panel data model}
\usage{
ssys_gmm(Y, model = c("onestep", "twosteps", "threesteps"))
}
\arguments{
\item{Y}{matrix of size (T x N) with the dependent variable}

\item{model}{one of: onestep, twosteps, threesteps; more steps should
increase efficiency, but might be computationally infeasible
(a singular matrix needs to be inverted); if this is the case,
generalised inverse is used}
}
\value{
The estimated value of the auto-regressive parameter.
}
\description{
Computes an enhanced version of the Blundell-Bond (System-GMM)
             estimator for panel data by means of replacing the standard
             GMM-weighting matrix by its sub-optimal version, thus increasing
             estimator's efficiency.
}
\references{
Youssef, A. and Abonazel, M. (2015). Alternative GMM estimators
            for first-order autoregressive panel model: An improving
            efficiency approach. MPRA Paper No. 68674; Forthcoming in:
            Communications in Statistics - Simulation and Computation,
            \url{https://mpra.ub.uni-muenchen.de/68674/1/MPRA_paper_68674.pdf}
}
\author{
Michal Oleszak
}
