% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.xgboost.R
\name{pmml.xgb.Booster}
\alias{pmml.xgb.Booster}
\title{Generate PMML for a xgb.Booster object from the xgboost package}
\usage{
\method{pmml}{xgb.Booster}(model, model.name = "xboost_Model",
  app.name = "R", description = "Extreme Gradient Boosting Model",
  copyright = NULL, transforms = NULL, inputFeatureNames = NULL,
  outputLabelName = NULL, outputCategories = NULL, xgbDumpFile = NULL,
  unknownValue = NULL, ...)
}
\arguments{
\item{model}{an object created by the 'xgboost' function}

\item{model.name}{optional; the model name.}

\item{app.name}{optional; name where the model was created.}

\item{description}{optional; description of the model.}

\item{copyright}{optional; a copyright statement.}

\item{transforms}{optional; any pre-processing information from the pmmlTransformations package.}

\item{inputFeatureNames}{input variable names used in training the model}

\item{outputLabelName}{name of the predicted field}

\item{outputCategories}{possible values of the predicted field, for classification models.}

\item{xgbDumpFile}{name of file saved using 'xgb.dump' function.}

\item{unknownValue}{optional; a missing value replacement.}

\item{...}{further arguments passed to other methods.}
}
\value{
PMML representation of the \code{xgb.Booster} object.
}
\description{
Generate PMML for a xgb.Booster object from the xgboost package
}
\details{
The \code{xgboost} function takes as its input either an \code{xgb.DMatrix} object or
a numeric matrix. The input field information is not stored in the R model object, 
hence the field information must be passed on as inputs. This enables the PMML 
to specify field names in its model representation. The R model object does not store 
information about the fitted tree structure either. However, this information can
be extracted from the \code{xgb.model.dt.tree} function and the file saved using the
\code{xgb.dump} function. The xgboost library is therefore needed in the environmant and this 
saved file is needed as an input as well.

The following objectives are currently supported: \code{multi:softprob},
\code{multi:softmax}, \code{binary:logistic}.

The pmml exporter will throw an error if the xgboost model model only has one tree.
}
\examples{
# Standard example using the xgboost package example model
# make the xgboost model using xgb.DMatrix object as inputs
\dontrun{
library(xgboost)
data(agaricus.train, package='xgboost')
data(agaricus.test, package='xgboost')
train <- agaricus.train
test <- agaricus.test
model1 <- xgboost(data = train$data, label = train$label, max_depth = 2,eta = 1, nthread = 2, 
                  nrounds = 2, objective = "binary:logistic")
}

# the input feature names for the xgb.DMatrix object can be extracted as colnames(train$data)
# the output field name and categories must be inferred. Looking at train$label informs us 
# that the output categories are either 0 or 1. The name cannot be inferred and so will be 
# given a name "prediction1" save the tree information required in an external file
\dontrun{
xgb.dump(model1, "model1.dumped.trees")
}
# Now all requiredinput parameters are known:
\dontrun{
pmml(model1,inputFeatureNames=colnames(train$data),outputLabelName="prediction1",
 outputCategories=c("0","1"),xgbDumpFile="model1.dumped.trees")
}

# use iris dataset to make a multinomial model
# input data as a matrix
\dontrun{
model2 <- xgboost(data = as.matrix(iris[,1:4]), label = as.numeric(iris[,5])-1, 
               max_depth = 2, eta = 1, nthread = 2, nrounds = 2, objective = "multi:softprob",
               num_class=3)
}
               
# The field names are easily extracted from the columnnames and the categories are converted to
# numeric format by xgboost.
# save the tree information file
\dontrun{
xgb.dump(model2, "model2.dumped.trees")

pmml(model2,inputFeatureNames=colnames(as.matrix(iris[,1:4])),outputLabelName="Species",
outputCategories=c(1,2,3),xgbDumpFile="model2.dumped.trees")
}

}
\seealso{
\code{\link[pmml]{pmml}},
\href{http://dmg.org/pmml/v4-3/GeneralStructure.html}{PMML Schema}
}
