% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateEstimationHelper.R
\name{sm}
\alias{sm}
\title{Fully-adapted particle filter for state estimate in a linear Gaussian state 
space model}
\usage{
sm(y, phi, sigmav, sigmae, nPart, T, x0)
}
\arguments{
\item{y}{Observations from the model for \eqn{t=1,...,T}.}

\item{phi}{The persistence of the state process \eqn{\phi}.}

\item{sigmav}{The standard deviation of the state process \eqn{\sigma_v}.}

\item{sigmae}{The standard deviation of the observation process \eqn{\sigma_e}.}

\item{nPart}{The number of particles to use in the filter.}

\item{T}{The number of observations.}

\item{x0}{The initial state.}
}
\value{
The function returns a list with the elements:
\itemize{
\item{xh: The estimate of the filtered state at time \eqn{t=1,...,T}.}
\item{ll: The estimate of the log-likelihood.}
\item{p: The particle system at each time point.}
\item{w: The particle weights at each time point.}
}
}
\description{
Estimates the filtered state and the log-likelihood for a linear Gaussian 
state space model of the form \eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } 
and \eqn{ y_t = x_t + \sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote 
independent standard Gaussian random variables, i.e.\eqn{N(0,1)}.
}
\note{
See Section 4 in the reference for more details.
}
\examples{
## Generates T=500 observations from a linear state space model with
## ( phi, sigma_e, sigma_v ) = ( 0.5, 1.0, 0.1 ) and zero initial state.

d  <- generateData(phi=0.5, sigmav=1.0, sigmae=0.1, T=500, x0=0.0) 

## Estimate the filtered state
xhatf <- sm(d$y, phi=0.5, sigmav=1.0, sigmae=0.1, nPart=20, 
T=500, x0=0.0)$xh

## Plot the estimate and the true state
par(mfrow=c(1,1))
plot(d$x, type="l", xlab="time", ylab="state")
lines(xhatf, lty="dashed",col="red")
}
\author{
Johan Dahlin <johan.dahlin@liu.se>
}
\references{
Dahlin, J. & Schoen, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2015.
}
\keyword{ts}

