% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getsda}
\alias{getsda}
\title{Perform structure/reaction directed analysis for peaks list.}
\usage{
getsda(list, rtcutoff = 10, freqcutoff = 10, corcutoff = NULL)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{freqcutoff}{cutoff of frequency of PMDs between RT cluster for peaks, default 10}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}
}
\value{
list with tentative isotope, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Perform structure/reaction directed analysis for peaks list.
}
\examples{
\donttest{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
std <- getstd(pmd)
sda <- getsda(std)
}
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{plotpaired}}
}
