\name{em.onestep.worker}
\alias{em.onestep.worker}
\title{One EM step for workers}
\description{
  One EM step only for model-based clustering of finite mixture Gaussian
  models with unstructured dispersions.
  This is a core function of \code{\link{em.step.worker}}.
}
\usage{
  em.onestep.worker(PARAM)
}
\arguments{
  \item{PARAM}{an original set of parameters generated
                   by \code{\link{set.global}}.}
}
\details{
  A global variable called \code{\link{X.worker}} should exist in the
  \code{\link[base]{.GlobalEnv}}
  environment, usually the working environment. The \code{\link{X.worker}}
  is the data matrix to be clustered, and this matrix has a dimension
  \code{N.worker} by \code{p}.

  The \code{PARAM} will be a local variable for the current iteration inside
  \code{\link{em.onestep.worker}},
  and this variable is a list containing all parameters related to models.
  This function also updates in the parameters by the EM algorithm, and
  return a new \code{\link{PARAM}} for the next iteration.
  The details of list elements are initially
  generated by \code{\link{set.global}}.
}
\value{
  This function is one EM step. The global variables will be updated and
  a new \code{\link{PARAM}} will be returned.
  See the help page of \code{\link{PARAM}} or \code{\link{PARAM.org}}
  for details.
}
\references{
  High Performance Statistical Computing Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/hpsc/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{e.step.worker}},
  \code{\link{m.step.worker}}.
}
\examples{
\dontrun{
# This is a core function for em.estep.worker()
# see the source code for details.
}
}
\keyword{core function}

