\name{apecm2.step.worker}
\alias{apecm2.step.worker}
\title{APECM2 steps for workers}
\description{
  The APECM2 algorithm for model-based clustering of finite mixture Gaussian
  models with unstructured dispersions.
}
\usage{
  apecm2.step.worker(PARAM.org)
}
\arguments{
  \item{PARAM.org}{an original set of parameters generated
                   by \code{\link{set.global}}.}
}
\details{
  A global variable called \code{\link{X.worker}} should exist in the
  \code{\link[base]{.GlobalEnv}}
  environment, usually the working environment. The \code{\link{X.worker}}
  is the data matrix to be clustered, and this matrix has a dimension
  \code{N.worker} by \code{p}.

  A \code{PARAM.org} will be a local variable inside
  \code{\link{apecm2.step.worker}},
  and this variable is a list containing all parameters related to models.
  This function also updates in the parameters by the APECM2 algorithm, and
  return the convergent results. The details of list elements are initially
  generated by \code{\link{set.global}}.
}
\value{
  A convergent results will be returned in the other list variables
  containing all new parameters which represent the components of models.
  See the help page of \code{\link{PARAM}} or \code{\link{PARAM.org}}
  for details.
}
\references{
  High Performance Statistical Computing Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/hpsc/}

  Chen, W.-C. and Ostrouchov, G. (2012)
  \dQuote{Parallel Model-Based Clustering for Finite Mixture Gaussian Models},
  \emph{(in preparation)}.
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{mb.print}},
  \code{\link{em.step.worker}},
  \code{\link{aecm.step.worker}}, \cr
  \code{\link{apecm1.step.worker}}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run in 4 processors by
# > mpirun -np 4 Rscript demo.r

### Setup mpi environment.
library(Rmpi)
library(pmclust)
invisible(mpi.comm.dup(0, 1))

### Generate an example data.
N.allworkers <- rep(5000, mpi.comm.size())
N.worker <- 5000
N.K.worker <- c(2000, 3000)
N <- 5000 * mpi.comm.size()
p <- 2
K <- 2
seed <- 123 + mpi.comm.rank()
data.worker <- generate.basic.worker(N.allworkers, N.worker, N.K.worker,
                                     N, p, K, seed)
X.worker <- data.worker$X.worker

### Run clustering.
PARAM.org <- set.global(K = K)
# PARAM.org <- initial.em.worker(PARAM.org)
PARAM.org <- initial.RandEM.worker(PARAM.org)
PARAM.new <- apecm1.step.worker(PARAM.org)
em.update.class.worker()

### Get results.
N.CLASS <- get.N.CLASS(K)
catmpi("# of class:", N.CLASS, "\n")

### Quit Rmpi.
mpi.quit()
}
}
\keyword{algorithm}

