% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{VIP}
\alias{VIP}
\alias{SR}
\alias{sMC}
\alias{LW}
\alias{RC}
\alias{SR}
\alias{sMC}
\alias{LW}
\alias{RC}
\title{Filter methods for variable selection with Partial Least Squares.}
\usage{
VIP(pls.object, opt.comp, p = dim(pls.object$coef)[1])

SR(pls.object, opt.comp, X)

sMC(pls.object, opt.comp, X, alpha_mc = 0.05)

LW(pls.object, opt.comp)

RC(pls.object, opt.comp)
}
\arguments{
\item{pls.object}{\code{mvr} object from PLS regression.}

\item{opt.comp}{optimal number of components of PLS model.}

\item{p}{number of variables in PLS model.}

\item{X}{data matrix used as predictors in PLS modelling.}

\item{alpha_mc}{quantile significance for automatic selection of variables in \code{sMC}.}
}
\value{
A vector having the same lenght as the number of variables in the associated
PLS model. High values are associated with high importance, explained variance or
relevance to the model.
}
\description{
Various filter methods extracting and using information from 
\code{mvr} objects to assign importance to all included variables. Available 
methods are Significance Multivariate Correlation (sMC), Selectivity Ratio (SR), 
Variable Importance in Projections (VIP), Loading Weights (LW), Regression Coefficients (RC).
}
\examples{
data(gasoline, package = "pls")
library(pls)
pls  <- plsr(octane ~ NIR, ncomp = 10, validation = "LOO", data = gasoline)
comp <- which.min(pls$validation$PRESS)
X    <- gasoline$NIR
vip <- VIP(pls, comp)
sr  <- SR (pls, comp, X)
smc <- sMC(pls, comp, X)
lw  <- LW (pls, comp)
rc  <- RC (pls, comp)
matplot(scale(cbind(vip, sr, smc, lw, rc)), type = 'l')

}
\references{
T. Mehmood, K.H. Liland, L. Snipen, S. Sæbø, A review of variable selection 
methods in Partial Least Squares Regression, Chemometrics and Intelligent Laboratory Systems
118 (2012) 62-69.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
