% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_model.extract.R
\name{model.frame.pdata.frame}
\alias{model.frame.pdata.frame}
\alias{formula.pdata.frame}
\alias{model.matrix.plm}
\alias{model.matrix.pdata.frame}
\title{model.frame and model.matrix for panel data}
\usage{
\method{model.frame}{pdata.frame}(
  formula,
  data = NULL,
  ...,
  lhs = NULL,
  rhs = NULL,
  dot = "previous"
)

\method{formula}{pdata.frame}(x, ...)

\method{model.matrix}{plm}(object, ...)

\method{model.matrix}{pdata.frame}(
  object,
  model = c("pooling", "within", "Between", "Sum", "between", "mean", "random", "fd"),
  effect = c("individual", "time", "twoways", "nested"),
  rhs = 1,
  theta = NULL,
  cstcovar.rm = NULL,
  ...
)
}
\arguments{
\item{data}{a \code{formula}, see \strong{Details},}

\item{\dots}{further arguments.}

\item{lhs}{inherited from package \code{\link[Formula:Formula]{Formula::Formula()}} (see
there),}

\item{rhs}{inherited from package \code{\link[Formula:Formula]{Formula::Formula()}} (see
there),}

\item{dot}{inherited from package \code{\link[Formula:Formula]{Formula::Formula()}} (see
there),}

\item{x}{a \code{model.frame}}

\item{object, formula}{an object of class \code{"pdata.frame"} or an
estimated model object of class \code{"plm"},}

\item{model}{one of \code{"pooling"}, \code{"within"}, \code{"Sum"}, \code{"Between"},
\code{"between"}, \verb{"random",} \code{"fd"} and \code{"ht"},}

\item{effect}{the effects introduced in the model, one of
\code{"individual"}, \code{"time"}, \code{"twoways"} or \code{"nested"},}

\item{theta}{the parameter for the transformation if \code{model = "random"},}

\item{cstcovar.rm}{remove the constant columns, one of \verb{"none", "intercept", "covariates", "all")},}
}
\value{
The \code{model.frame} methods return a \code{pdata.frame}.\cr The
\code{model.matrix} methods return a \code{matrix}.
}
\description{
Methods to create model frame and model matrix for panel data.
}
\details{
The \code{lhs} and \code{rhs} arguments are inherited from \code{Formula}, see
there for more details.\cr The \code{model.frame} methods return a
\code{pdata.frame} object suitable as an input to plm's
\code{model.matrix}.\cr The \code{model.matrix} methods builds a model matrix
with transformations performed as specified by the \code{model} and
\code{effect} arguments (and \code{theta} if \code{model = "random"} is
requested), in this case the supplied \code{data} argument should be a
model frame created by plm's \code{model.frame} method. If not, it is
tried to construct the model frame from the data. Constructing the
model frame first ensures proper NA handling, see \strong{Examples}.
}
\examples{

# First, make a pdata.frame
data("Grunfeld", package = "plm")
pGrunfeld <- pdata.frame(Grunfeld)

# then make a model frame from a formula and a pdata.frame
form <- inv ~ value
mf <- model.frame(pGrunfeld, form)

# then construct the (transformed) model matrix (design matrix)
# from model frame
modmat <- model.matrix(mf, model = "within")

## retrieve model frame and model matrix from an estimated plm object
fe_model <- plm(form, data = pGrunfeld, model = "within")
model.frame(fe_model)
model.matrix(fe_model)

# same as constructed before
all.equal(mf, model.frame(fe_model), check.attributes = FALSE) # TRUE
all.equal(modmat, model.matrix(fe_model), check.attributes = FALSE) # TRUE

}
\seealso{
\code{\link[=pmodel.response]{pmodel.response()}} for (transformed) response
variable.\cr \code{\link[Formula:Formula]{Formula::Formula()}} from package \code{Formula},
especially for the \code{lhs} and \code{rhs} arguments.
}
\author{
Yves Croissant
}
\keyword{classes}
