% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_segment_pick}
\alias{mosaic_segment_pick}
\title{Segments a mosaic interactively}
\usage{
mosaic_segment_pick(
  mosaic,
  basemap = NULL,
  g = 2,
  r = 3,
  b = 1,
  max_pixels = 2e+06,
  downsample = NULL,
  quantiles = c(0, 1),
  return = c("mosaic", "mask")
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{basemap}{An optional \code{mapview} object.}

\item{r, g, b}{The layer for the Red, Green and Blue band, respectively.
Defaults to \code{1}, \code{2}, and \code{3}.}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{quantiles}{the upper and lower quantiles used for color stretching.}

\item{return}{The output of the function. Either 'mosaic' (the segmented
mosaic), or 'mask' (the binary mask).}
}
\value{
An \code{SpatRaster} object with the segmented \code{mosaic} (if \code{return = 'mosaic'}) or a mask (if \code{return = 'mask'}).
}
\description{
The function segments a mosaic using an interative process where the user
picks samples from background (eg., soil) and foreground (eg., plants).
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
 mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
 seg <- mosaic_segment_pick(mosaic)
 mosaic_plot(seg)
}
}
