% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_plot}
\alias{mosaic_plot}
\title{A wrapper around terra::plot()}
\usage{
mosaic_plot(
  mosaic,
  col = custom_palette(c("red", "yellow", "forestgreen"), n = 200),
  smooth = TRUE,
  ...
)
}
\arguments{
\item{mosaic}{SpatRaster}

\item{col}{character vector to specify the colors to use. Defaults to
\code{custom_palette(c("red", "yellow", "forestgreen"))}.}

\item{smooth}{logical. If TRUE (default) the cell values are smoothed (only
if a continuous legend is used).}

\item{...}{Further arguments passed on to \code{\link[terra:plot]{terra::plot()}}.}
}
\value{
A \code{NULL} object
}
\description{
Plot the values of a SpatRaster
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
r <- mosaic_input(system.file("ex/elev.tif", package="terra"))
mosaic_plot(r)
}
}
