% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{image_prepare_mv}
\alias{image_prepare_mv}
\title{Prepare an image (align and crop)}
\usage{
image_prepare_mv(img, viewer = get_pliman_viewer())
}
\arguments{
\item{img}{An optional \code{Image} object}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}
}
\value{
The alighed/cropped image for further visualization or analysis.
}
\description{
This function aligns and crops the image using either base or mapview
visualization. This is useful to prepare the images to be analyzed with
\code{\link[=analyze_objects_shp]{analyze_objects_shp()}}
}
\examples{
# Example usage:
if(interactive()){
img <- image_pliman("mult_leaves.jpg")
image_prepare_mv(img, viewer = "mapview")
}
}
