% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHtoVPD.R
\name{RHtoVPD}
\alias{RHtoVPD}
\alias{VPDtoRH}
\alias{esat}
\alias{VPDtoDew}
\alias{DewtoVPD}
\alias{VPDleafToAir}
\alias{VPDairToLeaf}
\alias{RHleafToAir}
\alias{RHairToLeaf}
\title{Conversions between relative humidity, vapour pressure deficit and dewpoint}
\usage{
RHtoVPD(RH, TdegC, Pa = 101)

VPDtoRH(VPD, TdegC, Pa = 101)

esat(TdegC, Pa = 101)

VPDtoDew(VPD, TdegC, Pa = 101)

DewtoVPD(Tdew, TdegC, Pa = 101)

VPDleafToAir(VPD, Tleaf, Tair, Pa = 101)

VPDairToLeaf(VPD, Tair, Tleaf, Pa = 101)

RHleafToAir(RH, Tleaf, Tair, Pa = 101)

RHairToLeaf(RH, Tair, Tleaf, Pa = 101)
}
\arguments{
\item{RH}{Relative humidity (\%)}

\item{TdegC}{Temperature (degrees C) (either leaf or air)}

\item{Pa}{Atmospheric pressure (kPa)}

\item{VPD}{Vapour pressure deficit (kPa)}

\item{Tdew}{Dewpoint temperature (degrees C)}

\item{Tleaf}{Leaf temperature (degrees C)}

\item{Tair}{Air temperature (degrees C)}
}
\description{
A collection of functions to convert between relative humidity (RH) (\%), 
vapour pressure deficit (VPD) (kPa), 
dew point temperature, and leaf- or air temperature-based VPD or RH. To convert from 
relative humidity to VPD, 
use the \code{RHtoVPD} function,  use \code{VPDtoRH} for the other way around. The water 
vapor saturation pressure is 
calculated with \code{esat}. Use \code{DewtoVPD} to 
convert from dewpoint temperature to VPD. The functions \code{VPDleafToAir} and \code{VPDairToLeaf}
convert VPD from a leaf temperature to an air-temperature basis and vice versa. The 
functions \code{RHleafToAir} a \code{RHairToLeaf} do the same for relative humidity.
}
\details{
The function describing saturated vapor pressure with temperature is taken from 
Jones (1992). All other calculations follow directly from the standard definitions, for
 which Jones (1992) may also be consulted.
}
\references{
Jones, H.G. 1992. Plants and microclimate: a quantitative approach to 
environmental plant physiology. 2nd Edition., 2nd Edn. Cambridge University Press, Cambridge. 428 p.
}
\author{
Remko Duursma
}
