% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_git.R
\name{proj_git}
\alias{proj_git}
\title{Calculates the projected in transit for a defined DFU}
\usage{
proj_git(dataset, DFU, Period, ETA.Current, ETA.Next, ETD.Next, TLT)
}
\arguments{
\item{dataset}{a dataframe which contains the different variable below for each DFU}

\item{DFU}{name of a node, which is an item x location}

\item{Period}{a period of time, expressed in weekly bucket}

\item{ETA.Current}{quantities currently in transit displayed at their ETA date in units}

\item{ETA.Next}{quantities to be shipped, not yet in transit, displayed at their ETA date in units}

\item{ETD.Next}{quantities to be shipped, not yet in transit, displayed at their ETD date in units}

\item{TLT}{Transit Lead Time, expressed in weeks, represents the difference between ETA and ETD dates}
}
\value{
a dataframe with the projected in transit quantity calculated for each DFU
}
\description{
Calculates the projected in transit for a defined DFU
}
\examples{
proj_git(dataset = demo_in_transit, DFU, Period, ETA.Current, ETA.Next, ETD.Next, TLT)

}
