% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgdepends.R
\docType{package}
\name{pkgdepends-package}
\alias{pkgdepends}
\alias{pkgdepends-package}
\title{pkgdepends: Package Dependency Resolution and Downloads}
\description{
pkgdepends is a toolkit for package dependencies, downloads and
installations, to be used in other packages. If you are looking for a
package manager, see \href{https://github.com/r-lib/pak}{pak}.
}
\section{Features}{
\itemize{
\item Look up package dependencies recursively.
\item Visualize package dependencies.
\item Download packages and their dependencies.
\item Install downloaded packages.
\item Includes a dependency solver to find a consistent set of
dependencies.
\item Supports CRAN and Bioconductor packages automatically.
\item Supports packages on GitHub.
\item Supports local package file and trees.
\item Supports the \code{Remotes} entry in the \code{DESCRIPTION} file.
\item Caches metadata and downloaded packages via
\href{https://github.com/r-lib/pkgcache}{pkgcache}
\item Performs all downloads and HTTP queries concurrently.
\item Builds and installs packages in parallel.
}
}

\section{Install}{
Once on CRAN, install the package with:\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pkgdepends")
}\if{html}{\out{</div>}}
}

\section{Usage}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(pkgdepends)
}\if{html}{\out{</div>}}
\subsection{Package references}{

A package reference (ref) specifies a location from which an R package
can be obtained from. Examples:\preformatted{devtools
cran::devtools
bioc::Biobase
r-lib/pkgdepends
https://github.com/r-lib/pkgdepends
local::~/works/shiny
}

See \link[=pkg_refs]{“Package references”} for details.
}

\subsection{Package dependencies}{

Dependencies of the development version of the cli package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pd <- new_pkg_deps("r-lib/pkgcache")
pd$solve()
pd$draw()
}\if{html}{\out{</div>}}\preformatted{#> r-lib/pkgcache 1.2.2.9000 [new][bld][cmp][dl] (unknown size)
#> +-assertthat 0.2.1 [new][dl] (52.72 kB)
#> +-callr 3.7.0 [new][dl] (438.14 kB)
#> | +-processx 3.5.2 [new][dl] (296.19 kB)
#> | | +-ps 1.6.0 [new][dl] (285.82 kB)
#> | | \-R6 2.5.1 [new]
#> | \-R6
#> +-cli 3.0.1 [new]
#> | \-glue 1.4.2 [new][dl] (139.16 kB)
#> +-curl 4.3.2 [new][dl] (861.98 kB)
#> +-digest 0.6.28 [new]
#> +-filelock 1.0.2 [new][dl] (26.72 kB)
#> +-glue
#> +-jsonlite 1.7.2 [new][dl] (492.02 kB)
#> +-prettyunits 1.1.1 [new][dl] (34.71 kB)
#> +-R6
#> +-processx
#> +-rappdirs 0.3.3 [new][dl] (45.54 kB)
#> +-rlang 0.4.12 [new][dl] (1.33 MB)
#> +-tibble 3.1.5 [new]
#> | +-ellipsis 0.3.2 [new][dl] (36.44 kB)
#> | | \-rlang
#> | +-fansi 0.5.0 [new][dl] (237.78 kB)
#> | +-lifecycle 1.0.1 [new]
#> | | +-glue
#> | | \-rlang
#> | +-magrittr 2.0.1 [new][dl] (224.79 kB)
#> | +-pillar 1.6.4 [new][dl] (1.03 MB)
#> | | +-cli
#> | | +-crayon 1.4.1 [new][dl] (139.48 kB)
#> | | +-ellipsis
#> | | +-fansi
#> | | +-lifecycle
#> | | +-rlang
#> | | +-utf8 1.2.2 [new]
#> | | \-vctrs 0.3.8 [new][dl] (1.41 MB)
#> | |   +-ellipsis
#> | |   +-glue
#> | |   \-rlang
#> | +-pkgconfig 2.0.3 [new][dl] (17.80 kB)
#> | +-rlang
#> | \-vctrs
#> \-uuid 0.1-4 [new][dl] (27.79 kB)
#> 
#> Key:  [new] new | [dl] download | [bld] build | [cmp] compile
}

See the \code{\link{pkg_deps}} class for details.
}

\subsection{Package downloads}{

Downloading all dependencies of a package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pdl <- new_pkg_download_proposal("r-lib/cli")
pdl$resolve()
pdl$download()
}\if{html}{\out{</div>}}

See the \code{\link{pkg_download_proposal}} class for
details.
}

\subsection{Package installation}{

Installing or updating a set of package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{lib <- tempfile()
pdi <- new_pkg_installation_proposal(
  "r-lib/cli",
  config = list(library = lib)
)
pdi$solve()
pdi$download()
pdi$install()
}\if{html}{\out{</div>}}
}

\subsection{Dependency resolution}{

\code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} all resolve
their dependencies recursively, to obtain information about all packages
needed for the specified \link[=pkg_refs]{package references}. See
\link[=pkg_resolution]{“Dependency resolution”} for details.
}

\subsection{The dependency solver}{

The dependency solver takes the resolution information, and works out
the exact versions of each package that must be installed, such that
version and other requirements are satisfied. See \link[=pkg_solution]{“The dependency solver”} for details.
}

\subsection{Installation plans}{

\code{\link{pkg_installation_proposal}} can create
installation plans, and then also install them. It is also possible to
import installation plans that were created by other tools. See
\link[=install_plans]{“Installation plans”} for details.
}

\subsection{Configuration}{

The details of \code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} can be tuned
with a list of configuration options. See
\link[=pkgdepends-config]{“Configuration”} for details.
}
}

\section{Related}{
\itemize{
\item \href{https://github.com/r-lib/pak}{pak} – R package manager
\item \href{https://github.com/r-lib/pkgcache}{pkgcache} – Metadata and package
cache
\item \href{https://github.com/r-lib/devtools}{devtools} – Tools for R package
developers
}
}

\section{License}{
MIT (c) RStudio
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgdepends#readme}
  \item Report bugs at \url{https://github.com/r-lib/pkgdepends/issues}
}

}
