% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_try_each}
\alias{async_try_each}
\title{It runs each task in series but stops whenever any of the functions were
successful. If one of the tasks were successful, the callback will be
passed the result of the successful task. If all tasks fail, the
callback will be passed the error and result (if any) of the final
attempt.}
\usage{
async_try_each(..., .list = list())
}
\arguments{
\item{...}{Deferred values to run in series.}

\item{.list}{More deferred values to run, \code{.list} is easier to use
programmatically.}
}
\value{
Resolves to the result of the first successful deferred.
Otherwise throws an error. The error objects of all failed deferreds
will be in the \code{errors} member of the error object.
}
\description{
It runs each task in series but stops whenever any of the functions were
successful. If one of the tasks were successful, the callback will be
passed the result of the successful task. If all tasks fail, the
callback will be passed the error and result (if any) of the final
attempt.
}
\examples{
do <- function() {
  async_try_each(
    async(function() stop("doh"))(),
    async(function() "cool")(),
    async(function() stop("doh2"))(),
    async(function() "cool2")()
  )
}
synchronise(do())
}
\seealso{
Other async control flow: \code{\link{async_reflect}},
  \code{\link{async_retryable}}, \code{\link{async_retry}},
  \code{\link{async_sequence}}, \code{\link{async_until}},
  \code{\link{async_whilst}}
}
\concept{async control flow}
