% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_replicate}
\alias{async_replicate}
\title{Replicate an async function a number of times}
\usage{
async_replicate(n, task, ..., .limit = Inf)
}
\arguments{
\item{n}{Number of replications.}

\item{task}{Async function to call.}

\item{...}{Additional arguments to \code{task}.}

\item{.limit}{Number of concurrent async processes to create.}
}
\value{
Resolves to a list of the results of the \code{n} \code{task} calls.
}
\description{
Similar to \code{\link[base:replicate]{base::replicate()}}, with some differences:
\itemize{
\item it takes an async function, instead of an expression, and
\item it always returns a list.
}
}
\examples{
\donttest{
## perform an HTTP request three times, and list the reponse times
do <- function() {
  async_replicate(3,
    function() http_get("https://eu.httpbin.org")$then(function(x) x$times))
}
synchronise(do())
}
}
