% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sprinkle.R, R/sprinkle_print_method.R, R/sprinkle_table.R
\name{sprinkle}
\alias{sprinkle}
\alias{sprinkle_print_method}
\alias{sprinkle_table}
\title{Define Customizations to a Table}
\usage{
sprinkle(x, rows = NULL, cols = NULL, ..., part = c("body", "head",
  "foot", "interfoot", "table"))

sprinkle_print_method(x, print_method = c("console", "markdown", "html",
  "latex"))

sprinkle_table(x, cols = NULL, ..., part = "table")
}
\arguments{
\item{x}{A dust object}

\item{rows}{A numeric vector specifying the rows of the table to sprinkle.
See details for more about sprinkling.}

\item{cols}{A numeric (or character) vector specifying the columns (or
column names) to sprinkle.  See details for more about sprinkling.}

\item{...}{named arguments, each of length 1, defining the customizations
  for the given cells.  See "Sprinkles" for a listing of these arguments.}

\item{part}{A character string denoting which part of the table to modify.}

\item{print_method}{A character string giving the print method for the table.}
}
\description{
Customizations to a \code{dust} table are added by "sprinkling"
  with a little extra pixie dust.  Sprinkles are a collection of attributes
  to be applied over a subset of table cells.  They may be added to any
  part of the table, or to the table as a whole.
}
\details{
Sprinkling is done over the intersection of rows and columns.  If
  rows but no columns are specified, sprinkling is performed over all columns
  of the given given rows. The reverse is true for when columns but no rows
  are specified.  If neither columns nor rows are specified, the attribute
  is applied over all of the cells in the table part denoted in \code{part}.

  Whenever \code{part = "table"}, \code{rows} and \code{columns} are ignored
  and the attributes are applied to the entire table. This feature is not
  yet implemented (2015-08-05) and may be removed, depending on how useful
  it turns out to be.

  If at least one of \code{border}, \code{border_thickness}, \code{border_units},
  \code{border_style} or \code{border_color} is specified, the remaining
  unspecified attributes assume their default values.

  Other sprinkle pairings are \code{height} and \code{height_units};
  \code{width} and \code{width_units}; \code{font_size} and \code{font_size_units};
  \code{bg_pattern} and \code{bg_pattern_by}

  The sprinkles \code{bg} and \code{bg_pattern} may not be used together.

  A more detailed demonstration of the use of sprinkles is available in
  \code{vignette("pixiedust", package = "pixiedust")}

  In \code{sprinkle}, when \code{part = "table"}, the attributes are assigned to
  the entire table.  This is not yet active and may be removed entirely.

  The \code{sprinkle_table}, sprinkles may be applied to the columns of multiple tables. Table
  parts are required to have the same number of columns, but not necessarily the same number
  of rows, which is why the \code{rows} argument is not available for the \code{sprinkle_table}.
  In contrast to \code{sprinkle}, the \code{part} argument in \code{sprinkle} table will
  accept multiple parts.  If any of the named parts is \code{"table"}, the sprinkle will be
  applied to the columns of all of the parts.
}
\section{Sprinkles}{

The following list describes the valid sprinkles that may be defined in the
\code{...} dots argument.  All sprinkles may be defined for any output type, but
only sprinkles recognized by that output type will be applied.  For a complete
list of which sprinkles are recognized by each output type, see
\code{vignette("sprinkles", package = "pixiedust")}.

\itemize{
  \item{\code{bg} }{A character string denoting the color
     for the background.  See "Colors".}
  \item{\code{bg_pattern} }{This is one of the few exceptions to the length 1 rule.
     This accepts a vector of any length.  Background colors are recycled in a
     pattern. See "Colors". If left unspecified but \code{bg_pattern_by} is
     specified, this will default to \code{c("White", "Gray")}.}
  \item{\code{bg_pattern_by} }{A character string denoting if the background
     pattern is recycled over rows or columns.  Accepts either \code{"rows"},
     or \code{"columns"} with partial matching and defaults to \code{"rows"}.
     If \code{bg_pattern} is provided, \code{bg_pattern_by} is assumed, meaning
     it is not necessary to explicitly define \code{bg_pattern_by} unless
     changing an existing or default setting.}
  \item{\code{bold} }{Logical value.  If \code{TRUE}, text is rendered in bold.}
  \item{\code{border_collapse} }{Logical.  Defaults to \code{TRUE}.
     This element is only applicable to
     \code{part = "table"} and will be applied to the table regardless
     the value of \code{part} in the call.}
  \item{\code{border} }{This is one of the few exceptions to the length 1 rule.
     Accepts values \code{"left"}, \code{"right"}, \code{"top"},
     \code{"bottom"}, and \code{"all"} with partial matching.  The border will be added
     to the sides indicated.}
  \item{\code{border_thickness} }{A numeric value denoting the thickness
     of the border.  Defaults to \code{1}.}
  \item{\code{border_units} }{A character string taking any one of the
     values \code{"px"} or \code{"pt"} with partial matching.  Defaults
     to \code{"px"}.}
  \item{\code{border_style} }{A character string taking any one of the
     values \code{"solid"}, \code{"dashed"}, \code{"dotted"},
     \code{"double"}, \code{"groove"}, \code{"ridge"}, \code{"inset"},
     \code{"outset"}, \code{"hidden"}, or \code{"none"}.  Defaults
     to \code{"solid"}.}
  \item{\code{border_color} }{A character string denoting the color
     for the border.  See "Colors".}
  \item{\code{fn} }{A function to apply to values in cells.  The function
     should be an expression that acts on the variable \code{value}. For
     example, \code{quote(round(value, 3))}.}
  \item{\code{font_color} }{A character string denoting the color of the
     font.  See "Colors".}
  \item{\code{font_size} }{A numeric value denoting the size of the font.}
  \item{\code{font_size_units} }{A character string giving the units
    of the font size.  Accepts values \code{"px"}, \code{"pt"}, \code{"\%"},
    and \code{"em"}.  Defaults to \code{"pt"}.  LaTeX formats only recognize
    \code{"pt"} and \code{"em"}, and other units specifications will be
    coerced to \code{"pt"}, which may result in an unexpected appearance.}
  \item{\code{halign} }{A character string denoting the horizontal alignment.
    Accepts any one of the values \code{"left"}, \code{"center"}, or
    \code{"right"}, with partial matching.}
  \item{\code{height} }{A numerical value giving the height of the cells.}
  \item{\code{height_units} }{A character string giving the units for the
    \code{height} argument.  Accepts \code{"px"}, \code{"pt"}, \code{"cm"},
    \code{"in"} and \code{"\%"}. Defaults to \code{"pt"}.  LaTeX formats
    do not recognize \code{"px"} and this will be coerced to \code{"pt"} when
    submitted for LaTeX output.}
  \item{\code{italic} }{Logical value.  If \code{TRUE}, text is rendered in italics.}
  \item{\code{longtable} }{ Allows the user to print a table in multiple sections.
    This is useful when
    a table has more rows than will fit on a printed page.  Acceptable inputs are \code{FALSE},
    indicating that only one table is printed (default); \code{TRUE} that the table should be
    split into multiple tables with the default number of rows per table (see "Longtable"); or a
    positive integer indicating how many rows per table to include. All other values are
    interpreted as \code{FALSE}.}
  \item{\code{merge} }{Logical.  If \code{TRUE}, the cells indicated in
    \code{rows} and \code{cols} are merged into a single cell.  An error is
    cast if the cells do not form an adjacent block. Specifying
    \code{merge_rowval} or \code{merge_colval} without \code{merge} results
    in an error; \code{pixiedust} is conservative and will not assume you
    mean to merge cells--it must be explicitly declared.}
  \item{\code{merge_rowval} }{A numeric value of length 1 indicating the
    row position of the merged cells with the desired display text.  The
    value given must be an element of \code{rows}.  If no value is provided,
    the smallest value of \code{rows} is used.}
  \item{\code{merge_colval} }{A numeric value of length 1 indicating the
    column position of the merged cells with the desired display text. The
    value given must be an element of \code{cols}.  If no value is provided,
    the smallest value of \code{cols} is used.}
  \item{\code{na_string} }{A character value of length 1. Specifies how missing
    values (\code{NA}) are to be represented in the table.  Defaults to an
    empty character string (\code{""}).}
  \item{\code{pad} }{A numerical value giving the cell padding in pixels.}
  \item{\code{replace} }{A character vector (or vector to be coerced to character) that
    will replace the cells identified by \code{rows} and \code{cols}.  Replacement
    is always performed moving down columns first, then across rows from left to right.
    The operating assumption is that the most frequent use of this argument will be
    to replace entire columns.}
  \item{\code{rotate_degree} }{A numerical value that determines the angle of rotation
     in the clockwise direction.  Use negative values to rotate counter clockwise.}
  \item{\code{round} }{A numerical value for the number of decimal places to
     which numerical values are rounded.  This can also be accomplished through
     the \code{fn} argument, but this argument makes it a bit easier to do.  In cases where
     character values are indicated for rounding (such a a term name), no action is taken.
     This means that `sprinkle(x, round=3)` would round all numerical values in a table to three
     decimal places without affecting any true character values; there is no need to limit
     the `round` sprinkle to known numerical values.}
  \item{\code{valign} }{A character string giving the vertical alignment for the
     cells.  Accepts the values \code{"top"}, \code{"middle"}, or \code{"bottom"}
     with partial matching.}
  \item{\code{width} }{A numerical value giving the width of the cells.}
  \item{\code{width_units} }{A character string giving the units for the
    \code{width} argument.  Accepts \code{"px"}, \code{"pt"}, \code{"cm"},
    \code{"in"} and \code{"\%"}. Defaults to \code{"px"}.  LaTeX formats
    do not recognize \code{"px"} and this will be coerced to \code{"pt"} when
    submitted for LaTeX output.}
}
}

\section{Longtable}{

The \code{longtable} feature is named for the LaTeX package used to break very large
tables into multiple pages.

When using the \code{longtable=TRUE} option, the default number of rows per table is 25 for
console, HTML, and markdown output.  For LaTeX output, the number of rows is determined by
the LaTeX \code{longtable} package's algorithm. The number of rows per table only considers
the content in the body of the table.  Consideration for the number of rows in the head and
foot are the responsibility of the user.

Whenever a table is broken into multiple parts, each part retains the table head.  If any
\code{interfoot} is provided, it is appended to the bottom of each section, with the
exception of the last section.  The last section has the \code{foot} appended.
}

\section{HTML Colors}{

Color specifications accept X11 color names (\code{"orchid"}),
hexidecimal names (\code{"#DA70D6"}), rgb names (\code{"rgb(218 112 214)"}),
and rgba (rgb+alpha transparency; \code{"rgba(218, 112, 214, .75)"}).
Refer to \url{https://en.wikipedia.org/wiki/Web_colors#X11_color_names}.

HTML color names are not case sensitive, but the color names in LaTeX output
are.  If you desire to be able to toggle your output between HTML and LaTeX,
it is recommended that you use the color names under the dvips section of
page 38 of the LaTeX package \code{xcolor} manual
(\url{http://ctan.mirrorcatalogs.com/macros/latex/contrib/xcolor/xcolor.pdf}.
}

\section{LaTeX Colors}{

Use of color in LaTeX requirements requires that you have the LaTeX \code{color}
package included in your document preamble (\code{\\usepackage\{color\}}).
Rmarkdown documents include the color package automatically. The
standard colors available in LaTeX are "white", "black", "red", "green",
"blue", "cyan", "magenta", and "yellow".

Additional colors may be made available using the LaTeX package \code{xcolor}.
To be consistent with color names used in the HTML tables, it is recommended
that you use the option \code{\\usepackage[dvipsnames]\{xcolor\}} in your
preamble.  Please note that color names in LaTeX are case-sensitive, but the
HTML names are not.  If the ability to switch between output methods is
something you desire, you should adopt the capitalization used in the dvips
names (See page 38 of the \code{xcolor} manual;
\url{http://ctan.mirrorcatalogs.com/macros/latex/contrib/xcolor/xcolor.pdf}).

If desired, you may also use the \code{[x11names]} option to have the X11
color names available to you.

The LaTeX output will accept hexidecimal names (\code{"#DA70D6"}) and
rgb names (\code{"rgb(218 112 214)"}), similar to the HTML colors described
above.  However, transparency is not supported.  If the transparency
value is provided, it is silently ignored.

Custom color definitions may also be defined by defining the color in the
preamble.  The process for color definitions is described in the \code{xcolor}
documentation.  Keep in mind that custom color designations in LaTeX output
will not transfer the other output formats.
}

\section{Required LaTeX Packages}{

If you will be using the LaTeX output, some sprinkles will require you
to include additional LaTeX packages in your document preamble.  In
\code{.Rnw} files, additional packages can be included with the
\code{\\usepackage\{[package]\}} syntax.  In markdown, additional packages
are included using \code{header-includes:} in the YAML front matter with
a line of the format \code{\\usepackage\{[package]\}} for each package to
be used.  Sprinkles that require additional packages, and the LaTeX packages
required, are listed below:

\tabular{ll}{
  Sprinkle \tab LaTeX Package(s) \cr
  \code{font_color} \tab \code{\\usepackage[dvipsnames]\{xcolor\}} \cr
  \code{bg, bg_pattern} \tab \code{\\usepackage[dvipsnames,table]\{xcolor\}} \cr
}
}
\examples{
x <- dust(lm(mpg ~ qsec + factor(am), data = mtcars))
x \%>\% sprinkle(cols = 2:4, round = 3) \%>\%
  sprinkle(cols = 5, fn = quote(pvalString(value))) \%>\%
  sprinkle(rows = 2, bold = TRUE)
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{sprinkle_colnames}} for changing column names in a table.
}

