% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kelvin.R
\name{k_c}
\alias{k_c}
\alias{k_f}
\title{Covert to Kelvin scale}
\usage{
k_c(x)

k_f(x)
}
\arguments{
\item{x}{temperature in initial scale:
\itemize{
  \item for \code{k_c(x)} - in \href{https://en.wikipedia.org/wiki/Celsius}{Celsius}-scale, [\emph{°C}]
  \item for \code{k_f(x)} - in \href{https://en.wikipedia.org/wiki/Fahrenheit}{Fahrenheit}-scale, [\emph{°F}]
}
Type: \code{\link{assert_double}}.}
}
\value{
temperature in \emph{Kelvin}-scale, [\emph{K}]. Type: \code{\link{assert_double}}.
}
\description{
Convert temperature measured in
 \href{https://en.wikipedia.org/wiki/Celsius}{Celsius}- or
 \href{https://en.wikipedia.org/wiki/Fahrenheit}{Fahrenheit}-scale
 to \href{https://en.wikipedia.org/wiki/Kelvin}{Kelvin} (\emph{K}).
}
\examples{
 library(pipenostics)

# Convert from Celsius to Kelvin:
k_c(c(-273.15, 100))
# [1]  0  373.15

# Convert from Fahrenheit to Kelvin:
k_f(c(-459.67, 212))
# [1]  0  373.15

}
\seealso{
\code{\link{c_k}} and \code{\link{f_k}} for converting from Kelvin-scale.

Other units: 
\code{\link{c_k}()},
\code{\link{f_k}()},
\code{\link{inch_mm}()},
\code{\link{kgf_mpa}()},
\code{\link{loss_flux}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{units}
