% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b31gops.R
\name{b31gops}
\alias{b31gops}
\title{ASME B31G. Operational status of pipe}
\usage{
b31gops(wth, depth)
}
\arguments{
\item{wth}{nominal wall thickness of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{depth}{measured maximum depth of the corroded area, [\emph{inch}]. Type: \code{\link{assert_double}}.}
}
\value{
Operational status of pipe:
 \itemize{
   \item \emph{1} - excellent
   \item \emph{2} - monitoring is recommended
   \item \emph{3} - alert! replace the pipe immediately!
 }
 Type: \code{\link{assert_numeric}} and \code{\link{assert_subset}}.
}
\description{
Determine the operational status of pipe: is it excellent? or is
 technological control required? or is it critical situation?
}
\examples{
 b31gops(.438, .1)
 # [1] 2  # typical status for the most of pipes

 b31gops(.5, .41)
 # [1] 3  # alert! Corrosion depth is too high! Replace the pipe!

}
\references{
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31g.1991.pdf}{ASME B31G-1991}.
 Manual for determining the remaining strength of corroded pipelines. A
 supplement to \emph{ASTME B31} code for pressure piping.
}
\seealso{
Other ASME B31G functions: 
\code{\link{b31crvl}()},
\code{\link{b31gacd}()},
\code{\link{b31gacl}()},
\code{\link{b31gafr}()},
\code{\link{b31gdep}()},
\code{\link{b31gmodpf}()},
\code{\link{b31gpf}()},
\code{\link{b31gsap}()}
}
\concept{ASME B31G functions}
