% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_azure.R
\name{legacy_azure}
\alias{legacy_azure}
\alias{board_register_azure}
\title{Azure board (legacy API)}
\usage{
legacy_azure(
  container = Sys.getenv("AZURE_STORAGE_CONTAINER"),
  account = Sys.getenv("AZURE_STORAGE_ACCOUNT"),
  key = Sys.getenv("AZURE_STORAGE_KEY"),
  cache = NULL,
  name = "azure",
  ...
)

board_register_azure(
  name = "azure",
  container = Sys.getenv("AZURE_STORAGE_CONTAINER"),
  account = Sys.getenv("AZURE_STORAGE_ACCOUNT"),
  key = Sys.getenv("AZURE_STORAGE_KEY"),
  cache = NULL,
  path = NULL,
  ...
)
}
\arguments{
\item{container}{The name of the Azure Storage container.}

\item{account}{The name of the Azure Storage account.}

\item{key}{The access key for the Azure Storage container. You can find
this under "Access keys" in your storage account settings.

The \code{key} is equivalent to a password, so generally should not be stored
in your script. The easiest alternative is to store it in the
\code{AZURE_STORAGE_KEY} environment variable, which \code{legacy_azure()} will
use by default.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{...}{Additional parameters required to initialize a particular board.}

\item{path}{Subdirectory within \code{url}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

To use Microsoft Azure Storage as a board, you'll need an Azure Storage
account, an Azure Storage container, and an Azure Storage key.
}
\examples{
\dontrun{
# the following example requires an Azure Storage key
board_register_azure(
  container = "pinscontainer",
  account = "pinsstorage",
  key = "abcabcabcabcabcabcabcabcabcab=="
)
}
}
\keyword{internal}
