% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_rsconnect.R
\name{board_rsconnect}
\alias{board_rsconnect}
\title{Use RStudio Connect as board}
\usage{
board_rsconnect(
  auth = c("auto", "manual", "envvar", "rsconnect"),
  server = NULL,
  account = NULL,
  key = NULL,
  output_files = FALSE,
  cache = NULL,
  name = "rsconnect",
  versioned = TRUE,
  use_cache_on_failure = is_interactive(),
  versions = deprecated()
)
}
\arguments{
\item{auth}{There are three ways to authenticate:
\itemize{
\item \code{auth = "manual"} uses arguments \code{server} and \code{key}.
\item \code{auth = "envvar"} uses environment variables \code{CONNECT_API_KEY}
and \code{CONNECT_SERVER}.
\item \code{auth = "rsconnect"} uses servers registered with the rsconnect
package (filtered by \code{server} and \code{account}, if provided)
}

The default, \code{auth = "auto"}, automatically picks between the three options,
using \code{"manual"} if \code{server} and \code{key} are provided, \code{"envvar"} if both
environment variables are set, and \code{"rsconnect"} otherwise.}

\item{server}{For \code{auth = "manual"} or \code{auth = 'envvar'}, the full url to the server,
like \verb{http://server.rstudio.com/rsc} or \verb{https://connect.rstudio.com/}.
For \code{auth = 'rsconnect'} a host name used to disambiguate RSC accounts,
like \code{server.rstudio.com} or \code{connect.rstudio.com}.}

\item{account}{A user name used to disambiguate multiple RSC accounts.}

\item{key}{The RStudio Connect API key.}

\item{output_files}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} No longer supported.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{versioned}{Should this board be registered with support for versions?}

\item{use_cache_on_failure}{If the pin fails to download, is it ok to
use the last cached version? Defaults to \code{is_interactive()} so you'll
be robust to poor internet connectivity when exploring interactively,
but you'll get clear errors when the code is deployed.}

\item{versions}{Should this board be registered with support for versions?}
}
\description{
To use a RStudio Connect board, you need to first authenticate. The easiest
way to do so is by launching \strong{Tools} - \strong{Global Options} -
\strong{Publishing} - \strong{Connect}, and follow the instructions.

You can share pins with others in RStudio Connect by changing the viewers
of the document to specific users or groups. This is accomplished by opening
the new published pin and then changing access under the settings tab.
After you've shared the pin, it will be automatically available to others.
}
\section{Public pins}{
If your RSC instance allows it, you can share a pin publicly by setting the
access type to \code{all}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{board \%>\% pin_write(my_df, access_type = "all")
}\if{html}{\out{</div>}}

(You can also do this in RSC by setting "Access" to
"Anyone - no login required")

Now anyone can read your pin through \code{\link[=board_url]{board_url()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{board <- board_url(c(
  my_df = "https://connect.rstudioservices.com/content/3004/"
))
board \%>\% pin_read("my_df")
}\if{html}{\out{</div>}}

You can find the URL of a pin with \code{\link[=pin_browse]{pin_browse()}}.
}

\examples{
\dontrun{
board <- board_rsconnect()
# Share the mtcars with your team
board \%>\% pin_write(mtcars, "mtcars")

# Download a shared dataset
board \%>\% pin_read("timothy/mtcars")
}
}
\seealso{
Other boards: 
\code{\link{board_folder}()},
\code{\link{board_url}()}
}
\concept{boards}
