% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{pillar_options}
\alias{pillar_options}
\title{Package options}
\usage{
pillar_options
}
\description{
Options that affect display of tibble-like output.
}
\details{
These options can be set via \code{\link[=options]{options()}} and queried via \code{\link[=getOption]{getOption()}}.
For this, add a \code{pillar.} prefix (the package name and a dot) to the option name.
Example: for an option \code{foo}, use \code{options(pillar.foo = value)} to set it
and \code{getOption("pillar.foo")} to retrieve the current value.
An option value of \code{NULL} means that the default is used.
}
\section{Options for the pillar package}{

\itemize{
\item \code{print_max}: Maximum number of rows printed, default: \code{20}.
Set to \code{Inf} to always print all rows.
For compatibility reasons, \code{getOption("tibble.print_max")} and
\code{getOption("dplyr.print_max")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{print_min}: Number of rows printed if the table has more than
\code{print_max} rows, default: \code{10}.
For compatibility reasons, \code{getOption("tibble.print_min")} and
\code{getOption("dplyr.print_min")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{width}: Output width. Default: \code{NULL}
(use \code{getOption("width")}).
This can be larger than \code{getOption("width")}, in this case the output
of the table's body is distributed over multiple tiers for wide tibbles.
For compatibility reasons, \code{getOption("tibble.width")} and
\code{getOption("dplyr.width")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{max_footer_lines}: The maximum number of lines in the footer,
default: \code{7}. Set to \code{Inf} to turn off truncation of footer lines.
The \code{max_extra_cols} option still limits
the number of columns printed.
\item \code{max_extra_cols}: The maximum number of columns printed in the footer,
default: \code{100}. Set to \code{Inf} to show all columns.
Set the more predictable \code{max_footer_lines} to control the number
of footer lines instead.
\item \code{bold}: Use bold font, e.g. for column headers? This currently
defaults to \code{FALSE}, because many terminal fonts have poor support for
bold fonts.
\item \code{subtle}: Use subtle style, e.g. for row numbers and data types?
Default: \code{TRUE}.
\item \code{subtle_num}: Use subtle style for insignificant digits? Default:
\code{FALSE}, is also affected by the \code{subtle} option.
\item \code{neg}: Highlight negative numbers? Default: \code{TRUE}.
\item \code{sigfig}: The number of significant digits that will be printed and
highlighted, default: \code{3}. Set the \code{subtle} option to \code{FALSE} to
turn off highlighting of significant digits.
\item \code{min_title_chars}: The minimum number of characters for the column
title, default: \code{15}.  Column titles may be truncated up to that width to
save horizontal space. Set to \code{Inf} to turn off truncation of column
titles.
\item \code{min_chars}: The minimum number of characters wide to
display character columns, default: \code{3}.  Character columns may be
truncated up to that width to save horizontal space. Set to \code{Inf} to
turn off truncation of character columns.
\item \code{max_dec_width}: The maximum allowed width for decimal notation,
default: \code{13}.
\item \code{bidi}: Set to \code{TRUE} for experimental support for bidirectional scripts.
Default: \code{FALSE}. When this option is set, "left right override"
and "first strong isolate"
\href{https://www.w3.org/International/questions/qa-bidi-unicode-controls}{Unicode controls}
are inserted to ensure that text appears in its intended direction
and that the column headings correspond to the correct columns.
}
}

\examples{
# Default setting:
getOption("pillar.sigfig")
pillar(1.234567)

# Change for the duration of the session:
old <- options(pillar.sigfig = 6)
pillar(1.234567)

# Change back to the original value:
options(old)
pillar(1.234567)

# Local scope:
local({
  rlang::local_options(pillar.sigfig = 6)
  pillar(1.234567)
})
pillar(1.234567)
}
\keyword{datasets}
