% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulated_annealing.R
\name{simulated_annealing}
\alias{simulated_annealing}
\title{Perform simulated annealing algorithm for S and F matrices}
\usage{
simulated_annealing(
  S,
  Fmat = NULL,
  user_defined_min_max = NULL,
  do_matrix_checks = TRUE,
  niter = 500,
  step = 0.009,
  weight.upper.bound = 30,
  verbose = TRUE
)
}
\arguments{
\item{S}{Sample data matrix – a matrix of pigment samples}

\item{Fmat}{Pigment to Chl a matrix}

\item{user_defined_min_max}{data frame with some format as min_max built-in data}

\item{do_matrix_checks}{This should only be set to TRUE when using the default values. This will remove pigment columns that have column sums of 0. Set to FALSE if using customised names for pigments and phytoplankton groups}

\item{niter}{Number of iterations (default is 500)}

\item{step}{Step ratio used (default is 0.009)}

\item{weight.upper.bound}{Upper limit of the weights applied (default value is 30).}

\item{verbose}{Logical value. Output error and temperature at each iteration. Default value of TRUE}
}
\value{
A list containing
\enumerate{
\item Fmat matrix
\item RMSE (Root Mean Square Error)
\item condition number
\item Class abundances
\item Figure (plot of results)
\item MAE (Mean Absolute Error)
\item Error
}
}
\description{
Perform simulated annealing algorithm for S and F matrices
}
\examples{
# Using the built-in matrices Sm and Fm
set.seed(5326)
sa.example <- simulated_annealing(Sm, Fm, niter = 5)
sa.example$Figure
}
