% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{blood_vol_Nadler}
\alias{blood_vol_Nadler}
\alias{blood_vol_Lemmens_sedentary}
\alias{blood_vol_Lemmens_indexed}
\alias{blood_vol_Lemmens_non_obese}
\title{Estimate Blood Volume}
\usage{
blood_vol_Nadler(height_m, weight_kg, male, ...)

blood_vol_Lemmens_sedentary(height_m, weight_kg, ...)

blood_vol_Lemmens_indexed(height_m, weight_kg, ...)

blood_vol_Lemmens_non_obese(weight_kg, age_y, male, ...)
}
\arguments{
\item{height_m}{single numeric, height in meters}

\item{weight_kg}{numeric vector of weight(s) in kg}

\item{male}{logical}

\item{...}{arguments passed to downstream functions, e.g. \code{warn = TRUE}}

\item{age_y}{numeric vector, age(s) in years. Extremely exact age is not
required, so for age in days or months, simplest just to divide. This is
not used in the calculation itself, so may be missing.}
}
\value{
numeric vector
}
\description{
estimate blood volume according to the classic 1960s paper by
  Nadler. Surgery. 1962 Feb;51(2):224-32. Prediction of blood volume in
  normal human adults. Nadler SB, Hidalgo JH, Bloch T.

This effectively reverses engineers an ideal weight from BMI of
22, then use the square root of its ratio to actual body weight to adjust
the 70ml per kg of an ideal weight person. Age-dependent regression
equations for indexed blood volume \code{InBV} at ideal body weight. (No
adjustment made in obesity by Lemmens.) \code{InBV = 90-0.4 X age} (males) \code{InBV = 85-0.4 X age} (females).

applies to slim adults, but note that the age-related decline is
  not seen if high degree of physical activity is maintained. TODO: check BMI
  not elevated
}
\examples{
blood_vol_Nadler(1.8, 80, male = TRUE)
blood_vol_Nadler(1.8, 160, male = TRUE)
blood_vol_Nadler(1.8, 80, male = FALSE)
blood_vol_Lemmens_sedentary(1.8, 80)
blood_vol_Lemmens_sedentary(1.8, 160)
blood_vol_Lemmens_indexed(1.8, 80)
blood_vol_Lemmens_indexed(1.8, 160)
  blood_vol_Lemmens_non_obese(80, age_y = 25, male = TRUE)
  blood_vol_Lemmens_non_obese(80, age_y = 75, male = TRUE)
}
\references{
'Davy KP, Seals DR. Total blood volume in healthy young and older
  men. J Appl Physiol 1994; 76: 2059-62'

  'Parker-Jones P, Davy KP, DeSouza CA et al. Absence of age-related decline
  in total blood volume in physically active females. Am J Physiol 1997; 272:
  H2534-40'
}
