% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{ideal_weight_Traub}
\alias{ideal_weight_Traub}
\title{ideal weight for child per Traub}
\source{
\url{http://www.ncbi.nlm.nih.gov/pubmed/6823980}
}
\usage{
ideal_weight_Traub(height_m, age_y = NULL, ...)
}
\arguments{
\item{height_m}{single numeric, height in meters}

\item{age_y}{numeric vector, age(s) in years. Extremely exact age is not
required, so for age in days or months, simplest just to divide. This is
not used in the calculation itself, so may be missing.}

\item{...}{arguments passed to downstream functions, e.g. \code{warn = TRUE}}
}
\description{
\code{2.396e0.01863(height)}, where height is in cm. There is an
argument for using another package to capture durations, of which age is a
special case. However, I am resisting bringing in external dependencies,
and for almost all use-cases I can imagine, the age will be captured as a
single number of one type, not a mix of types. Note that gender does not
appear to be important in this relationship.

See package AGD for CDC growth chart data.
}
\examples{
# will warn if given age is not in validate range from publication:
\dontrun{
  ideal_weight_child(height_m = 0.5, age_y = 0, do_warn = TRUE)
  ideal_weight_child(0.8, age_y = 11 / 12, do_warn = TRUE)
  ideal_weight_child(0.5, age_y = 25/365, do_warn = TRUE)
}
  ideal_weight_child(0.5, age_y = 25 / 365, do_warn = FALSE)
  ideal_weight_child(1, age_y = 2)
}
