% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acidbase.R
\name{henderson_hasselbalch}
\alias{henderson_hasselbalch}
\title{pH by Henderson Hasselbalch equation}
\usage{
henderson_hasselbalch(bicarbonate, pp_co2)
}
\arguments{
\item{bicarbonate}{mmol/L}

\item{pp_co2}{partial pressure of carbon dioxide in mmHg}
}
\description{
Calculate the pH based on bicarbonate and partial pressure of CO2
}
\examples{
 bicarbonate <- seq(10, 50, 5)
 pp_co2 <- seq(20, 70, 10)
 bc <- rep(bicarbonate, length(pp_co2))
 pp <- rep(pp_co2, each = length(bicarbonate))
 acidbase <- matrix(henderson_hasselbalch(bc, pp), nrow = 9, ncol = 6)
 rownames(acidbase) <- paste("bicarb", bicarbonate)
 colnames(acidbase) <- paste("PaCO2", pp_co2)
 acidbase
}
