% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-utils.R
\name{get_design_matrix}
\alias{get_design_matrix}
\title{\code{get_design_matrix} gets design matrix for gaussian, binomial, and poisson models}
\usage{
get_design_matrix(formula, data, random.effects, na.action = NULL)
}
\arguments{
\item{formula}{A two-sided linear formula object describing the
mixed-effects of the model; it follows similar syntax with \code{\link[lme4:lmer]{lmer}}.
There are some differences though.

First, to specify that a random term should have phylogenetic cov matrix along
with non-phylogenetic one, add \code{__} (two underscores) at the end of the group variable,
e.g. \code{+ (1 | sp__)} will construct two random terms,
one with phylogenetic cov matrix and another with non-phylogenetic (Identity) matrix;
However, \code{__} in the nested terms (below) will only create a phlylogenetic cov-matrix.
Therefore, nested random term has four forms:
\enumerate{
\item \code{(1|sp__@site)} represents correlated species are nested within independent sites
(i.e. kronecker(I_sites, V_sp)). This should be the most common one for community analysis (to test for overdispersion or underdispersion).
\item \code{(1|sp@site__)} represents independent species are nested within correlated sites
(i.e. kron(V_sites, I_sp)). This one can be used for bipartite questions.
You can, for example, treat sp as insects and site as plants with \code{(1|insects@plants__)}.
Remember to add the phylogeny of plants in the argument \code{cov_ranef = list(plants = plant_phylo)}.
\item \code{(1|sp__@site__)} represents correlated species are nested within correlated sites
(i.e. kron(V_sites, V_sp)). This one can also be used for bipartite questions such as
pollinators and plants (e.g. \code{(1|pollinators__@plants__)}). Remember to add their phylogenies
in the argument \code{cov_ranef = list(pollinators = pollinator_phylo, plants = plant_phylo)}.
\item \code{(1|sp@site)} will generate a identity matrix, which will be the same as
an observation level random term or the residual of LMM. So not very meaningful for gaussian models;
observation-level random term will be automatically added for binomial and poisson models.
}

Second, note that correlated random terms will not be allowed at this moment. For example,
\code{(x|g)} will be equal with \code{(0 + x|g)} in the \code{lme4::lmer} syntax;
also, \code{(x1 + x2|g)} won't work.}

\item{data}{A \code{\link{data.frame}} containing the variables named in formula.}

\item{random.effects}{Optional pre-build list of random effects. If \code{NULL} (the default),
the function \code{\link{prep_dat_pglmm}} will prepare it for you based on the information
in \code{formula}, \code{data}, and \code{cov_ranef}. A list of pre-generated
random terms is also accepted (mainly to be compatible with code from previous versions).
If so, make sure that the orders of rows and columns of var-cov matrices in the generated
list are the same as their corresponding group variables in the data. This argument can be
useful if users want to use more complicated random terms.}

\item{na.action}{What to do with NAs?}
}
\value{
A list of design matrices.
}
\description{
\code{get_design_matrix} gets design matrix for gaussian, binomial, and poisson models
}
