% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_beta.R
\name{unifrac}
\alias{unifrac}
\title{UniFrac distance}
\usage{
unifrac(x, phy)
}
\arguments{
\item{x}{a community matrix, i.e. an object of class matrix or Matrix, or an
object of class phyloseq.}

\item{phy}{a phylogenetic tree (object of class phylo).}
}
\value{
a dist object.
}
\description{
\code{unifrac} calculates the unweighted UniFrac distance between
communities.
}
\examples{
tree <- ape::read.tree(text ="((t1:1,t2:1)N2:1,(t3:1,t4:1)N3:1)N1;")
com <- Matrix::sparseMatrix(c(1,3,4,1,4,5,1,2,3,4,5,6,3,4,6),
  c(1,1,1,2,2,2,3,3,3,3,3,3,4,4,4),x=1,
  dimnames = list(paste0("g", 1:6), tree$tip.label))

unifrac(com, tree)
}
\references{
Lozupone C, Knight R. (2005) UniFrac: a new phylogenetic method for comparing
microbial communities. \emph{Appl Environ Microbiol.} \strong{71 (12)}:8228--35.
\emph{BMC Bioinformatics} 7:371.
}
\seealso{
\code{\link{PD}}, \code{\link{phylobeta}}
}
\keyword{cluster}
