% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.ed.ses.R
\name{.rast.ed.B}
\alias{.rast.ed.B}
\title{Calculate Evolutionary distinctiveness for each raster cell}
\usage{
.rast.ed.B(x, edge.path, branch.length, n.descen, filename = "", ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) must be sorted according to the
tree order. See the phylo.pres function.}

\item{edge.path}{matrix representing the paths through the tree from root
to each tip. See \code{\link{phylo.pres}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{n.descen}{numeric. A Named numeric vector of number of descendants for
each branch. See \code{\link{phylo.pres}}}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
This function calculates evolutionary distinctiveness according
to the fair-proportion index.
}
\references{
Isaac, N. J., Turvey, S. T., Collen, B.,
Waterman, C. and Baillie,
J. E. (2007). Mammals on the EDGE: conservation priorities
based on threat
and phylogeny. PLoS ONE 2, e296.
}
\author{
Gabriela Alves-Ferreira and Neander Marcel Heming
}
\keyword{internal}
