% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd.R
\name{ph_pd}
\alias{ph_pd}
\title{pd - Faith's index of phylogenetic diversity}
\usage{
ph_pd(sample, phylo)
}
\arguments{
\item{sample}{(data.frame/character) sample data.frame or path to a
sample file. required}

\item{phylo}{(character/phylo) One of: phylogeny as a newick string (will be
written to a temp file) - OR path to file with a newick
string - OR a an \pkg{ape} \code{phylo} object. required.}
}
\value{
A single data.frame, with the colums:
\itemize{
\item sample - community name/label
\item ntaxa - number of taxa
\item pd - Faith's phylogenetic diversity
\item treebl - tree BL
\item proptreebl - proportion tree BL
}
}
\description{
Calculates Faith’s (1992) index of phylogenetic diversity (PD) for
each sample in the phylo.
}
\examples{
sfile <- system.file("examples/sample_comstruct", package = "phylocomr")
pfile <- system.file("examples/phylo_comstruct", package = "phylocomr")

# from data.frame
sampledf <- read.table(sfile, header = FALSE,
  stringsAsFactors = FALSE)
phylo_str <- readLines(pfile)
ph_pd(sample = sampledf, phylo = phylo_str)

# from files
sample_str <- paste0(readLines(sfile), collapse = "\\n")
sfile2 <- tempfile()
cat(sample_str, file = sfile2, sep = '\\n')
pfile2 <- tempfile()
phylo_str <- readLines(pfile)
cat(phylo_str, file = pfile2, sep = '\\n')

ph_pd(sample = sfile2, phylo = pfile2)
}
\seealso{
Other phylogenetic-diversity: 
\code{\link{ph_rao}()}
}
\concept{phylogenetic-diversity}
