#' Spectral data for LEDs supplied by Roithner Laser
#'
#' Names of datasets containing the wavelengths and tabulated values for spectral
#' emittance for different light emitting diodes (LEDs) and LED arrays supplied
#' by Roithner Laser (Austria). Data are normalized to one at the wavelength of
#' maximum emission.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @examples
#' roithner_laser
#'
#' @note
#' Roithner LaserTechnik is a distributor and reseller of LEDs, LED arrays and
#' lasers. They have a very extensive catalogue covering almost wavelengths for
#' which LEDs are manufactured.
#' 
#' @references \url{http://www.roithner-laser.com/}
#'
#' @seealso \code{\link{leds.mspct}}
#' 
#' @family manufacturers
#' 
"roithner_laser"
