#' Spectral data for LEDs supplied by TaoYuan
#'
#' Datasets containing the wavelengths and tabulated values spectral emittance
#' for different light emitting diodes (LEDs) from TaoYuan Electron (HK). Data
#' are normalized to one at the wavelength of maximum emission.
#'
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @examples
#' tao_yuan
#' leds.mspct[tao_yuan]
#'
#' @note
#' TaoYuan Electron (HK) is a supplier of LEDs and LED arrays.
#' \url{http://www.ledwv.com/en/}
#'
"tao_yuan"
