% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials-mspct.r
\docType{data}
\name{materials.mspct}
\alias{materials.mspct}
\title{Total reflectance of materials}
\format{
A reflector_mspct object containing a collection of reflector_spct
  each with 491 rows and 2 variables.
}
\usage{
materials.mspct
}
\description{
Total reflectance of materials. Data are to be used as "reference values
only" as actual values will vary.
}
\details{
The variables for each spectrum are as follows:

\itemize{ \item w.length (nm) \item Rfr (fraction) }
}
\note{
This is a small selection from the ASTER database. See:
  https://speclib.jpl.nasa.gov/. Reproduced from the ECOSTRESS Spectral
  Library through the courtesy of the Jet Propulsion Laboratory, California
  Institute of Technology, Pasadena, California. Copyright (c) 2017, California
  Institute of Technology. ALL RIGHTS RESERVED.
}
\examples{
library(ggspectra)

names(materials.mspct)
cat(comment(materials.mspct$black.loam))
autoplot(materials.mspct$black.loam, annotations = c("+", "title:what"),
         range = c(NA, 800))

}
\references{
Meerdink, S. K., Hook, S. J., Roberts, D. A., & Abbott, E. A.
  (2019). The ECOSTRESS spectral library version 1.0. Remote Sensing of
  Environment, 230(111196), 1–8. ASTER spectral library.

  Baldridge, A. M., S.J. Hook, C.I. Grove and G. Rivera, 2009.. The ASTER
  Spectral Library Version 2.0. Remote Sensing of Environment, vol 113, pp.
  711-715.
}
\keyword{datasets}
