% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.response.R
\name{resp_spct}
\alias{resp_spct}
\title{Calculate response from spectral response}
\usage{
resp_spct(spct, w.band, unit.out, quantity, time.unit, wb.trim, use.hinges, ...)
}
\arguments{
\item{spct}{an object of class response_spct"}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{unit.out}{character with allowed values "energy", and "photon", or its
alias "quantum"}

\item{quantity}{character with allowed values "total", "average" ("mean"),
"contibution", "contribution.pc", "relative", "relative.pc"}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}
}
\value{
a single numeric value expressed either as a fraction of one or a
  percentage, or a vector of the same length as the list of wave.bands.
}
\description{
This function returns the mean response for a given waveband and a response
spectrum.
}
\note{
The parameter \code{use.hinges} controls speed optimization. The
  defaults should be suitable in mosts cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\keyword{internal}

