% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.R
\name{midpoint}
\alias{midpoint}
\alias{midpoint.default}
\alias{midpoint.numeric}
\alias{midpoint.waveband}
\alias{midpoint.generic_spct}
\alias{midpoint.generic_mspct}
\title{Central wavelength value}
\usage{
midpoint(x, ...)

\method{midpoint}{default}(x, ...)

\method{midpoint}{numeric}(x, ...)

\method{midpoint}{waveband}(x, ...)

\method{midpoint}{generic_spct}(x, ...)

\method{midpoint}{generic_mspct}(x, ..., idx = !is.null(names(x)))
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A numeric value equal to (max(x) - min(x)) / 2. In the case of spectral
objects a wavelength in nm. For any other R object, according to available
definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A function that returns the wavelength at the center of the wavelength range.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{numeric}: Default method for generic function

\item \code{waveband}: Wavelength at center of a "waveband".

\item \code{generic_spct}: Method for "generic_spct".

\item \code{generic_mspct}: Method for "generic_mspct" objects.
}}

\examples{
midpoint(sun.spct)

}
\seealso{
Other wavelength summaries: \code{\link{min}},
  \code{\link{range}}, \code{\link{stepsize}}

Other wavelength summaries: \code{\link{min}},
  \code{\link{range}}, \code{\link{stepsize}}

Other wavelength summaries: \code{\link{min}},
  \code{\link{range}}, \code{\link{stepsize}}
}
