% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{peaks}
\alias{peaks}
\alias{peaks.default}
\alias{peaks.numeric}
\alias{peaks.data.frame}
\alias{peaks.generic_spct}
\alias{peaks.source_spct}
\alias{peaks.response_spct}
\alias{peaks.filter_spct}
\alias{peaks.reflector_spct}
\alias{peaks.solute_spct}
\alias{peaks.cps_spct}
\alias{peaks.raw_spct}
\alias{peaks.generic_mspct}
\alias{peaks.source_mspct}
\alias{peaks.response_mspct}
\alias{peaks.filter_mspct}
\alias{peaks.reflector_mspct}
\alias{peaks.solute_mspct}
\alias{peaks.cps_mspct}
\alias{peaks.raw_mspct}
\title{Peaks or local maxima}
\usage{
peaks(
  x,
  span,
  global.threshold,
  local.threshold,
  local.reference,
  threshold.range,
  strict,
  na.rm,
  ...
)

\method{peaks}{default}(
  x,
  span = NA,
  global.threshold = NA,
  local.threshold = NA,
  local.reference = NA,
  threshold.range = NA,
  strict = NA,
  na.rm = FALSE,
  ...
)

\method{peaks}{numeric}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  ...
)

\method{peaks}{data.frame}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  x.var.name = NULL,
  y.var.name = NULL,
  var.name = y.var.name,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{generic_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{source_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{response_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{filter_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{reflector_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{solute_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{cps_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{raw_spct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{generic_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{source_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{response_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{filter_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{reflector_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{solute_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{cps_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{raw_mspct}(
  x,
  span = 5,
  global.threshold = NULL,
  local.threshold = NULL,
  local.reference = "median",
  threshold.range = NULL,
  strict = FALSE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{numeric vector. Hint: to find valleys, change the sign of the
argument with the unnary operator \code{-}.}

\item{span}{odd positive integer A peak is defined as an element in a
sequence which is greater than all other elements within a moving window of
width \code{span} centred at that element. The default value is 5, meaning
that a peak is taller than its four nearest neighbours. \code{span = NULL}
extends the span to the whole length of \code{x}.}

\item{global.threshold}{numeric A value belonging to class \code{"AsIs"} is
interpreted as an absolute minimum height or depth expressed in data units.
A bare \code{numeric} value (normally between 0.0 and 1.0), is interpreted
as relative to \code{threshold.range}. In both cases it sets a
\emph{global} height (depth) threshold below which peaks (valleys) are
ignored. A bare negative \code{numeric} value indicates the \emph{global}
height (depth) threshold below which peaks (valleys) are be ignored. If
\code{global.threshold = NULL}, no threshold is applied and all peaks
returned.}

\item{local.threshold}{numeric A value belonging to class \code{"AsIs"} is
interpreted as an absolute minimum height (depth) expressed in data units
relative to a within-window computed reference value. A bare \code{numeric}
value (normally between 0.0 and 1.0), is interpreted as expressed in units
relative to \code{threshold.range}. In both cases \code{local.threshold}
sets a \emph{local} height (depth) threshold below which peaks (valleys)
are ignored. If \code{local.threshold = NULL} or if \code{span} spans the
whole of \code{x}, no threshold is applied.}

\item{local.reference}{character One of \code{"median"} or \code{"farthest"}.
The reference used to assess the height of the peak, either the
minimum/maximum value within the window or the median of all values in the
window.}

\item{threshold.range}{numeric vector If of length 2 or a longer vector
\code{range(threshold.range)} is used to scale both thresholds. With
\code{NULL}, the default, \code{range(x)} is used, and with a vector of
length one \code{range(threshold.range, x)} is used, i.e., the range
is expanded.}

\item{strict}{logical flag: if \code{TRUE}, an element must be strictly
greater than all other values in its window to be considered a peak.
Default: \code{FALSE} (since version 0.13.1).}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}

\item{...}{ignored}

\item{var.name, x.var.name, y.var.name}{character Name of column where to look
for peaks.}

\item{refine.wl}{logical Flag indicating if peak location should be refined
by fitting a function.}

\item{method}{character String with the name of a method. Currently only
spline interpolation is implemented.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to local maxima.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\details{
Function \code{find_peaks} is a wrapper built onto function
  \code{\link[splus2R]{peaks}} from \pkg{splus2R}, adds support for peak
  height thresholds and handles \code{span = NULL} and non-finite (including
  NA) values differently than \code{splus2R::peaks}. Instead of giving an
  error when \code{na.rm = FALSE} and \code{x} contains \code{NA} values,
  \code{NA} values are replaced with the smallest finite value in \code{x}.
  \code{span = NULL} is treated as a special case and selects \code{max(x)}.
  Passing `strict = TRUE` ensures that multiple global and within window
  maxima are ignored, and can result in no peaks being returned.

  Two tests make it possible to ignore irrelevant peaks. One test
  (\code{global.threshold}) is based on the absolute height of the peaks and
  can be used in all cases to ignore globally low peaks. A second test
  (\code{local.threshold}) is available when the window defined by `span`
  does not include all observations and can be used to ignore peaks that are
  not locally prominent. In this second approach the height of each peak is
  compared to a summary computed from other values within the window of width
  equal to \code{span} where it was found. In this second case, the reference
  value used within each window containing a peak is given by
  \code{local.reference}. Parameter \code{threshold.range} determines how the
  values passed as argument to \code{global.threshold} and
  \code{local.threshold} are scaled. The default, \code{NULL} uses the range
  of \code{x}. Thresholds for ignoring too small peaks are applied after
  peaks are searched for, and threshold values can in some cases
  result in no peaks being returned.

  While functions \code{find_peaks} and \code{find_valleys()} accept as input
  a \code{numeric} vector and return a \code{logical} vector, methods
  \code{\link{peaks}} and \code{\link{valleys}} accept as input different R
  objects, including spectra and collections of spectra and return a subset
  of the object. These methods are implemented using calls to functions
  \code{find_peaks} and \code{\link{fit_peaks}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{peaks(default)}: Default returning always NA.

\item \code{peaks(numeric)}: Default function usable on numeric vectors.

\item \code{peaks(data.frame)}: Method for "data.frame" objects.

\item \code{peaks(generic_spct)}: Method for "generic_spct" objects.

\item \code{peaks(source_spct)}: Method for "source_spct" objects.

\item \code{peaks(response_spct)}: Method for "response_spct" objects.

\item \code{peaks(filter_spct)}: Method for "filter_spct" objects.

\item \code{peaks(reflector_spct)}: Method for "reflector_spct" objects.

\item \code{peaks(solute_spct)}: Method for "solute_spct" objects.

\item \code{peaks(cps_spct)}: Method for "cps_spct" objects.

\item \code{peaks(raw_spct)}: Method for "raw_spct" objects.

\item \code{peaks(generic_mspct)}: Method for "generic_mspct" objects.

\item \code{peaks(source_mspct)}: Method for "source_mspct" objects.

\item \code{peaks(response_mspct)}: Method for "cps_mspct" objects.

\item \code{peaks(filter_mspct)}: Method for "filter_mspct" objects.

\item \code{peaks(reflector_mspct)}: Method for "reflector_mspct" objects.

\item \code{peaks(solute_mspct)}: Method for "solute_mspct" objects.

\item \code{peaks(cps_mspct)}: Method for "cps_mspct" objects.

\item \code{peaks(raw_mspct)}: Method for "raw_mspct" objects.

}}
\note{
The default for parameter \code{strict} is \code{FALSE} in functions
  \code{peaks()} and \code{find_peaks()}, as in \code{stat_peaks()} and in
  \code{stat_valleys()}, while the default in \code{\link[splus2R]{peaks}}
  is \code{strict = FALSE}.
}
\examples{
# default span = 5
peaks(sun.spct)
# global maximum
peaks(sun.spct, span = NULL)
peaks(sun.spct, span = NULL)$w.length
# fitted peak wavelength
peaks(sun.spct, span = NULL, refine.wl = TRUE)
peaks(sun.spct, span = NULL, refine.wl = TRUE)$w.length
# a wider window
peaks(sun.spct, span = 51)
# global threshold relative to the range of s.e.irrad values
peaks(sun.spct, global.threshold = 0.7)
peaks(sun.spct, global.threshold = -0.3)
# global threshold in actual s.e.irrad values
peaks(sun.spct, global.threshold = 0.7, threshold.range = c(0, 1))
# local threshold  relative to the range of s.e.irrad values
peaks(sun.spct, local.threshold = 0.1)
# local threshold in actual s.e.irrad values
peaks(sun.spct, local.threshold = 0.1, threshold.range = c(0, 1))
# local threshold  relative to the range of s.e.irrad values, using window
# median instead of window minimum
peaks(sun.spct, local.threshold = 0.05, local.reference = "median")
# minimum, the default.
peaks(sun.spct, local.threshold = 0.05, local.reference = "farthest")

peaks(sun.spct)

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{spikes}()},
\code{\link{valleys}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
