% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct-conversion-qty-unit.R
\name{T2A}
\alias{T2A}
\alias{T2A.default}
\alias{T2A.numeric}
\alias{T2A.filter_spct}
\alias{T2A.filter_mspct}
\title{Convert transmittance into absorbance.}
\usage{
T2A(x, action, byref, clean, ...)

\method{T2A}{default}(x, action = NULL, byref = FALSE, ...)

\method{T2A}{numeric}(x, action = NULL, byref = FALSE, clean = TRUE, ...)

\method{T2A}{filter_spct}(x, action = "add", byref = FALSE, clean = TRUE, strict.A = FALSE, ...)

\method{T2A}{filter_mspct}(
  x,
  action = "add",
  byref = FALSE,
  clean = TRUE,
  strict.A = TRUE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object.}

\item{action}{character Allowed values \code{"replace"} and \code{"add"}.}

\item{byref}{logical indicating if new object will be created by reference
or by copy of \code{x}.}

\item{clean}{logical replace off-boundary values before conversion}

\item{...}{not used in current version}

\item{strict.A}{logical Attempt to compute a true internal absorbance even
if \code{"total"} transmittance is stored in \code{x}.}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x} with a column \code{A} added and other columns
  possibly deleted except for \code{w.length}. If \code{action = "replace"},
  in all cases, the additional columns are removed, even if no column needs
  to be added.
}
\description{
Function that converts transmittance (fraction) into \eqn{\log_{10}}-based
absorbance (a.u.).
}
\details{
Absorbance, \eqn{A}, is frequently used in chemistry as it is linearly
related to the concentration of a solute dissolved in a solvent.

\deqn{A = -\log_{10} \tau}

where, \eqn{A} absorbance and \eqn{\tau} is internal transmittance. By
default, if total transmittance, \eqn{T}, is stored in \code{x}, the
returned value computed as

\deqn{A = -\log_{10} T}

is not strictly absorbance. In this
case and in cases when the measured light attenuation is the result of
scattering, or when part of measured light is re-emitted after absorption
the use of \emph{attenuance} is the IUPAC-recommended name for this quantity.

If \code{strict.A = TRUE} is passed in the call and total
transmittance, \eqn{T}, and total
reflectance, \eqn{\rho}, are both available, absorbance is computed as:

\deqn{A = -\log_{10} (T - \rho) / (1 - \rho)}

where \eqn{\rho} can be either spectral total reflectance stored in \code{x}
as data or a single approximate \code{Rfr.constant} value stored as part
of the metadata.
}
\section{Methods (by class)}{
\itemize{
\item \code{T2A(default)}: Default method for generic function

\item \code{T2A(numeric)}: Method for numeric vectors

\item \code{T2A(filter_spct)}: Method for filter spectra

\item \code{T2A(filter_mspct)}: Method for collections of filter spectra

}}
\note{
The default \code{A.strict = FALSE} ensures indentical behaviour
  as in 'photobiology' (<= 0.11.0).
}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2q}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
