% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.spikes.R
\name{spikes}
\alias{spikes}
\alias{spikes.default}
\alias{spikes.numeric}
\alias{spikes.data.frame}
\alias{spikes.generic_spct}
\alias{spikes.source_spct}
\alias{spikes.response_spct}
\alias{spikes.filter_spct}
\alias{spikes.reflector_spct}
\alias{spikes.solute_spct}
\alias{spikes.cps_spct}
\alias{spikes.raw_spct}
\alias{spikes.generic_mspct}
\alias{spikes.source_mspct}
\alias{spikes.response_mspct}
\alias{spikes.filter_mspct}
\alias{spikes.reflector_mspct}
\alias{spikes.solute_mspct}
\alias{spikes.cps_mspct}
\alias{spikes.raw_mspct}
\title{Spikes}
\usage{
spikes(x, z.threshold, max.spike.width, na.rm, ...)

\method{spikes}{default}(x, z.threshold = NA, max.spike.width = 8, na.rm = FALSE, ...)

\method{spikes}{numeric}(x, z.threshold = NA, max.spike.width = 8, na.rm = FALSE, ...)

\method{spikes}{data.frame}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  y.var.name = NULL,
  var.name = y.var.name
)

\method{spikes}{generic_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  var.name = NULL,
  ...
)

\method{spikes}{source_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{spikes}{response_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{spikes}{filter_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  ...
)

\method{spikes}{reflector_spct}(x, z.threshold = 9, max.spike.width = 8, na.rm = FALSE, ...)

\method{spikes}{solute_spct}(x, z.threshold = 9, max.spike.width = 8, na.rm = FALSE, ...)

\method{spikes}{cps_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  var.name = "cps",
  ...
)

\method{spikes}{raw_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  var.name = "counts",
  ...
)

\method{spikes}{generic_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  var.name = NULL,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{source_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{response_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{filter_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{reflector_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{solute_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{cps_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  var.name = "cps",
  .parallel = FALSE,
  .paropts = NULL
)

\method{spikes}{raw_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE,
  ...,
  var.name = "counts",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{z.threshold}{numeric Modified Z values larger than \code{z.threshold}
are considered to correspond to spikes.}

\item{max.spike.width}{integer Wider regions with high Z values are not
detected as spikes.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for spikes.}

\item{...}{ignored}

\item{var.name, y.var.name}{character Name of column where to look
for spikes.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to spikes.
}
\description{
Function that returns a subset of an R object with observations corresponding
to spikes. Spikes are values in spectra that are unusually high compared to
neighbors. They are usually individual values or very short runs of similar
"unusual" values. Spikes caused by cosmic radiation are a frequent problem in
Raman spectra. Another source of spikes are "hot pixels" in CCD and diode
arrays.
}
\section{Methods (by class)}{
\itemize{
\item \code{spikes(default)}: Default returning always NA.

\item \code{spikes(numeric)}: Default function usable on numeric vectors.

\item \code{spikes(data.frame)}: Method for "data.frame" objects.

\item \code{spikes(generic_spct)}: Method for "generic_spct" objects.

\item \code{spikes(source_spct)}: Method for "source_spct" objects.

\item \code{spikes(response_spct)}: Method for "response_spct" objects.

\item \code{spikes(filter_spct)}: Method for "filter_spct" objects.

\item \code{spikes(reflector_spct)}: Method for "reflector_spct" objects.

\item \code{spikes(solute_spct)}: Method for "solute_spct" objects.

\item \code{spikes(cps_spct)}: Method for "cps_spct" objects.

\item \code{spikes(raw_spct)}: Method for "raw_spct" objects.

\item \code{spikes(generic_mspct)}: Method for "generic_mspct" objects.

\item \code{spikes(source_mspct)}: Method for "source_mspct" objects.

\item \code{spikes(response_mspct)}: Method for "cps_mspct" objects.

\item \code{spikes(filter_mspct)}: Method for "filter_mspct" objects.

\item \code{spikes(reflector_mspct)}: Method for "reflector_mspct" objects.

\item \code{spikes(solute_mspct)}: Method for "solute_mspct" objects.

\item \code{spikes(cps_mspct)}: Method for "cps_mspct" objects.

\item \code{spikes(raw_mspct)}: Method for "raw_mspct" objects.

}}
\examples{
spikes(sun.spct)

}
\seealso{
See the documentation for \code{\link{find_spikes}} for details of
  the algorithm and implementation.

Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{valleys}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
