% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalized.diff.idx.r
\name{normalized_diff_ind}
\alias{normalized_diff_ind}
\alias{normalised_diff_ind}
\alias{NDxI}
\alias{normalized_diff_ind.default}
\alias{normalized_diff_ind.generic_spct}
\alias{normalized_diff_ind.generic_mspct}
\title{Calculate a normalized index.}
\usage{
normalized_diff_ind(spct, plus.w.band, minus.w.band, f, ...)

normalised_diff_ind(spct, plus.w.band, minus.w.band, f, ...)

NDxI(spct, plus.w.band, minus.w.band, f, ...)

\method{normalized_diff_ind}{default}(spct, plus.w.band, minus.w.band, f, ...)

\method{normalized_diff_ind}{generic_spct}(spct, plus.w.band, minus.w.band, f, ...)

\method{normalized_diff_ind}{generic_mspct}(spct, plus.w.band, minus.w.band, f, ...)
}
\arguments{
\item{spct}{an R object}

\item{plus.w.band}{waveband objects The waveband determine the
region of the spectrum used in the calculations}

\item{minus.w.band}{waveband objects The waveband determine the
region of the spectrum used in the calculations}

\item{f}{function used for integration taking spct as first argument and a
list of wavebands as second argument.}

\item{...}{additional arguments passed to f}
}
\value{
A named numeric value for the index, or a tibble depending on whether
  a spectrum or a collection of spectra is passed as first argument. If
  the wavelength range of \code{spct} does not fully overlap with both
  wavebands \code{NA} is silently returned.
}
\description{
This method returns a normalized difference index value for an arbitrary
pair of wavebands. There are many such indexes in use, such as NDVI
(normalized difference vegetation index), NDWI (normalized difference water
index), NDMI (normalized difference moisture index), etc., the only
difference among then is in the wavebands used.
}
\details{
\code{f} is most frequently \code{\link{reflectance}}, but also
  \code{\link{transmittance}}, or even \code{\link{absorbance}},
  \code{\link{response}}, \code{\link{irradiance}} or a user-defined function
  can be used if there is a good reason for it. In every case \code{spct}
  should be of the class expected by \code{f}. When using two wavebands of
  different widths do consider passing to \code{f} a suitable \code{quantity}
  argument. Wavebands can describe weighting functions if desired.
}
\section{Methods (by class)}{
\itemize{
\item \code{normalized_diff_ind(default)}: default

\item \code{normalized_diff_ind(generic_spct)}: 

\item \code{normalized_diff_ind(generic_mspct)}: 

}}
\note{
Some NDxI indexes are directly based on satellite instrument data, such
  as those in the Landsat satellites. To simulate such indexes using spectral
  reflectande as input, \code{waveband} definitions provided by package
  'photobiologyWavebands' can be used.

\code{normalised_diff_ind()} is a synonym for \code{normalized_diff_ind()}.

\code{NDxI()} is a shorthand for \code{normalized_diff_ind()}.
}
