% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caverphone.R
\name{caverphone}
\alias{caverphone}
\title{Caverphone}
\usage{
caverphone(word, maxCodeLen = NULL, modified = FALSE, clean = TRUE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}

\item{modified}{if \code{TRUE}, use the Caverphone 2 algorithm}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}
}
\value{
the Caverphone encoded character vector
}
\description{
The Caverphone family of phonetic algorithms
}
\details{
The variable \code{maxCodeLen} is the limit on how long the returned
Caverphone code should be.  The default is 6, unless \code{modified}
is set to \code{TRUE}, then the default is 10.

The variable \code{modified} directs \code{caverphone} to use the
Caverphone2 method, instead of the original.

The \code{caverphone} algorithm is only defined for inputs over the
standard English alphabet, \emph{i.e.}, "A-Z.". Non-alphabetical
characters are removed from the string in a locale-dependent fashion.
This strips spaces, hyphens, and numbers.  Other letters, such as
"Ü," may be permissible in the current locale but are unknown to
\code{caverphone}.  For inputs outside of its known range, the output is
undefined and \code{NA} is returned and a \code{warning} this thrown.
If \code{clean} is \code{FALSE}, \code{caverphone} attempts to process the
strings.  The default is \code{TRUE}.
}
\examples{
caverphone("William")
caverphone(c("Peter", "Peady"), modified = TRUE)
caverphone("Stevenson", maxCodeLen = 4)

}
\references{
David Hood, "Caverphone: Phonetic matching algorithm," Technical
Paper CTP060902, University of Otago, New Zealand, 2002.

David Hood, "Caverphone Revisited," Technical Paper CTP150804
University of Otago, New Zealand, 2004.

James P. Howard, II, "Phonetic Spelling Algorithm Implementations
for R," \emph{Journal of Statistical Software}, vol. 25, no. 8,
(2020), p. 1--21, <10.18637/jss.v095.i08>.
}
\seealso{
Other phonics: 
\code{\link{cologne}()},
\code{\link{lein}()},
\code{\link{metaphone}()},
\code{\link{mra_encode}()},
\code{\link{nysiis}()},
\code{\link{onca}()},
\code{\link{phonex}()},
\code{\link{phonics}()},
\code{\link{rogerroot}()},
\code{\link{soundex}()},
\code{\link{statcan}()}
}
\concept{phonics}
